package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsOperateRoleResourcesetRequest;
import com.xforceplus.ucenter.client.model.MsOperateRoleResourcesetResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "roleResourceset", description = "the roleResourceset API")
public interface RoleResourcesetApi {

    @ApiOperation(value = "操作角色功能集", notes = "", response = MsOperateRoleResourcesetResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysRoleResourceset", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateRoleResourcesetResponse.class) })
    @RequestMapping(value = "/roleResourceset/operateRoleResourceset",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateRoleResourcesetResponse operateRoleResourceset(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateRoleResourcesetRequest request);

}
