package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsDeleteRoleUserRelByTenantIdRequest;
import com.xforceplus.ucenter.client.model.MsDeleteRoleUserRelByTenantIdResponse;
import com.xforceplus.ucenter.client.model.MsGetRoleListByUserIdRequest;
import com.xforceplus.ucenter.client.model.MsGetRoleListByUserIdResponse;
import com.xforceplus.ucenter.client.model.MsGetRoleUserRelListRequest;
import com.xforceplus.ucenter.client.model.MsGetRoleUserRelListResponse;
import com.xforceplus.ucenter.client.model.MsGetUserListByRoleIdRequest;
import com.xforceplus.ucenter.client.model.MsGetUserListByRoleIdResponse;
import com.xforceplus.ucenter.client.model.MsOperateRoleUserRelExtRequest;
import com.xforceplus.ucenter.client.model.MsOperateRoleUserRelExtResponse;
import com.xforceplus.ucenter.client.model.MsOperateRoleUserRelRequest;
import com.xforceplus.ucenter.client.model.MsOperateRoleUserRelResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "roleUserRel", description = "the roleUserRel API")
public interface RoleUserRelApi {

    @ApiOperation(value = "当缺省集团改为实体集团时 根据集团id删除对应的角色信息，更换和集团相关的tenantId", notes = "", response = MsDeleteRoleUserRelByTenantIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "roleUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsDeleteRoleUserRelByTenantIdResponse.class) })
    @RequestMapping(value = "/roleUserRel/deleteRoleUserRelByTenantId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsDeleteRoleUserRelByTenantIdResponse deleteRoleUserRelByTenantId(@ApiParam(value = "request" ,required=true ) @RequestBody MsDeleteRoleUserRelByTenantIdRequest request);


    @ApiOperation(value = "获取人员角色关联信息列表", notes = "", response = MsGetRoleListByUserIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "roleUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetRoleListByUserIdResponse.class) })
    @RequestMapping(value = "/roleUserRel/getRoleListByUserId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetRoleListByUserIdResponse getRoleListByUserId(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetRoleListByUserIdRequest request);


    @ApiOperation(value = "获取人员角色关联信息列表", notes = "", response = MsGetRoleUserRelListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "roleUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetRoleUserRelListResponse.class) })
    @RequestMapping(value = "/roleUserRel/getRoleUserRelList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetRoleUserRelListResponse getRoleUserRelList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetRoleUserRelListRequest request);


    @ApiOperation(value = "获取人员角色关联信息列表", notes = "", response = MsGetUserListByRoleIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "roleUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetUserListByRoleIdResponse.class) })
    @RequestMapping(value = "/roleUserRel/GetUserListByRoleId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetUserListByRoleIdResponse getUserListByRoleId(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserListByRoleIdRequest request);


    @ApiOperation(value = "操作人员角色关联信息", notes = "", response = MsOperateRoleUserRelResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "roleUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateRoleUserRelResponse.class) })
    @RequestMapping(value = "/roleUserRel/operateRoleUserRel",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateRoleUserRelResponse operateRoleUserRel(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateRoleUserRelRequest request);


    @ApiOperation(value = "操作人员角色关联信息", notes = "", response = MsOperateRoleUserRelExtResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "roleUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateRoleUserRelExtResponse.class) })
    @RequestMapping(value = "/roleUserRel/operateRoleUserRelExt",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateRoleUserRelExtResponse operateRoleUserRelExt(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateRoleUserRelExtRequest request);

}
