package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetApiUrlListRequest;
import com.xforceplus.ucenter.client.model.MsGetApiUrlListResponse;
import com.xforceplus.ucenter.client.model.MsGetCompanyIdListRequest;
import com.xforceplus.ucenter.client.model.MsGetCompanyIdListResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "security", description = "the security API")
public interface SecurityApi {

    @ApiOperation(value = "获取服务Api列表", notes = "", response = MsGetApiUrlListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysSecurity", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetApiUrlListResponse.class) })
    @RequestMapping(value = "/security/getApiUrlList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetApiUrlListResponse getApiUrlList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetApiUrlListRequest request);


    @ApiOperation(value = "获取服务Api列表", notes = "", response = MsGetCompanyIdListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysSecurity", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetCompanyIdListResponse.class) })
    @RequestMapping(value = "/security/getCompanyIdList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetCompanyIdListResponse getCompanyIdList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetCompanyIdListRequest request);

}
