package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.*;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "serviceApi", description = "the serviceApi API")
public interface ServiceApiApi {

    @ApiOperation(value = "根据资源码id获取相同appId服务Api列表", notes = "", response = MsGetSameServiceApiListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysServiceApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetSameServiceApiListResponse.class) })
    @RequestMapping(value = "/serviceApi/getSameServiceApiList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetSameServiceApiListResponse getSameServiceApiList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetSameServiceApiListRequest request);


    @ApiOperation(value = "获取服务Api信息", notes = "", response = MsGetServiceApiDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysServiceApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetServiceApiDetailResponse.class) })
    @RequestMapping(value = "/serviceApi/getServiceApiDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetServiceApiDetailResponse getServiceApiDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetServiceApiDetailRequest request);


    @ApiOperation(value = "获取服务Api列表", notes = "", response = MsGetServiceApiListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysServiceApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetServiceApiListResponse.class) })
    @RequestMapping(value = "/serviceApi/getServiceApiList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetServiceApiListResponse getServiceApiList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetServiceApiListRequest request);


    @ApiOperation(value = "操作服务Api", notes = "", response = MsOperateServiceApiResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysServiceApi", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateServiceApiResponse.class) })
    @RequestMapping(value = "/serviceApi/operateServiceApi",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateServiceApiResponse operateServiceApi(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateServiceApiRequest request);

    @ApiOperation(value = "获取资源码管理列表", notes = "", response = MsGetServiceApiListResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SysServiceApi", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetServiceApiMgrListResponse.class) })
    @RequestMapping(value = "/serviceApi/getServiceApiMgrList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetServiceApiMgrListResponse getServiceApiMgrList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetServiceApiMgrListRequest request);

    @ApiOperation(value = "删除服务Api", notes = "", response = MsOperateServiceApiResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SysServiceApi", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsOperateServiceApiResponse.class) })
    @RequestMapping(value = "/serviceApi/deleteNoRelServiceApi",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsOperateServiceApiResponse deleteNoRelServiceApi(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateServiceApiRequest request);

    @ApiOperation(value = "新增服务Api", notes = "", response = MsOperateServiceApiResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SysServiceApi", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsOperateServiceApiResponse.class) })
    @RequestMapping(value = "/serviceApi/addNoRelServiceApi",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsOperateServiceApiResponse addNoRelServiceApi(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateServiceApiRequest request);

}
