package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.*;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "user", description = "the user API")
public interface UserApi {

    @ApiOperation(value = "验证人员信息", notes = "", response = MsCheckUserResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "user", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsCheckUserResponse.class) })
    @RequestMapping(value = "/user/checkUser",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsCheckUserResponse checkUser(@ApiParam(value = "request" ,required=true ) @RequestBody MsCheckUserRequest request);


    @ApiOperation(value = "获取人员信息", notes = "", response = MsGetUserDetailResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "user", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetUserDetailResponse.class) })
    @RequestMapping(value = "/user/getUserDetail",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetUserDetailResponse getUserDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserDetailRequest request);


    @ApiOperation(value = "根据姓名/工号/手机号/邮箱查询人员详情", notes = "", response = MsGetUserDetailsByOptionsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "user", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetUserDetailsByOptionsResponse.class) })
    @RequestMapping(value = "/user/getUserDetailsByOptions",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetUserDetailsByOptionsResponse getUserDetailsByOptions(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserDetailsByOptionsRequest request);


    @ApiOperation(value = "获取人员列表", notes = "", response = MsGetUserListResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "user", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetUserListResponse.class) })
    @RequestMapping(value = "/user/getUserList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetUserListResponse getUserList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserListRequest request);


    @ApiOperation(value = "人员列表", notes = "", response = MsGetUserListResponse.class, tags={ "user", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetUserListResponse.class) })
    @RequestMapping(value = "/users",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetUserListResponse list(@ApiParam(value = "request" ,required=true ) @RequestBody MsSysUserQueryRequest request);


    @ApiOperation(value = "根据组织ID企业ID获取人员列表", notes = "", response = MsGetUserListByOrgCmpIdResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "user", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetUserListByOrgCmpIdResponse.class) })
    @RequestMapping(value = "/user/getUserListByOrgStructId",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetUserListByOrgCmpIdResponse getUserListByOrgCmpId(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserListByOrgCmpIdRequest request);


    @ApiOperation(value = "人员操作", notes = "", response = MsOperateUserResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "user", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsOperateUserResponse.class) })
    @RequestMapping(value = "/user/operateUser",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsOperateUserResponse operateUser(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateUserRequest request);

}
