package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetRoleListByUserGroupRequest;
import com.xforceplus.ucenter.client.model.MsGetRoleListResponse;
import com.xforceplus.ucenter.client.model.MsGetUserGroupDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetUserGroupDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetUserGroupListRequest;
import com.xforceplus.ucenter.client.model.MsGetUserGroupListResponse;
import com.xforceplus.ucenter.client.model.MsGetUserListByUserGroupRequest;
import com.xforceplus.ucenter.client.model.MsGetUserListResponse;
import com.xforceplus.ucenter.client.model.MsOperateUserGroupRelRoleRequest;
import com.xforceplus.ucenter.client.model.MsOperateUserGroupRelRoleResponse;
import com.xforceplus.ucenter.client.model.MsOperateUserGroupRelUserRequest;
import com.xforceplus.ucenter.client.model.MsOperateUserGroupRelUserResponse;
import com.xforceplus.ucenter.client.model.MsOperateUserGroupRequest;
import com.xforceplus.ucenter.client.model.MsOperateUserGroupResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "userGroup", description = "the userGroup API")
public interface UserGroupApi {

    @ApiOperation(value = "查询用户组与角色关联信息", notes = "", response = MsGetRoleListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "user_group", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetRoleListResponse.class) })
    @RequestMapping(value = "/userGroup/roleList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetRoleListResponse getRoleList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetRoleListByUserGroupRequest request);


    @ApiOperation(value = "获取用户组信息", notes = "", response = MsGetUserGroupDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "user_group", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetUserGroupDetailResponse.class) })
    @RequestMapping(value = "/userGroup/getUserGroupDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetUserGroupDetailResponse getUserGroupDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserGroupDetailRequest request);


    @ApiOperation(value = "获取用户组列表", notes = "", response = MsGetUserGroupListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "user_group", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetUserGroupListResponse.class) })
    @RequestMapping(value = "/userGroup/getUserGroupList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetUserGroupListResponse getUserGroupList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserGroupListRequest request);


    @ApiOperation(value = "查询用户组与用户关联信息", notes = "", response = MsGetUserListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "user_group", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetUserListResponse.class) })
    @RequestMapping(value = "/userGroup/userList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetUserListResponse getUserList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserListByUserGroupRequest request);


    @ApiOperation(value = "操作用户组信息", notes = "", response = MsOperateUserGroupResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "user_group", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateUserGroupResponse.class) })
    @RequestMapping(value = "/userGroup/operateUserGroup",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateUserGroupResponse operateUserGroup(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateUserGroupRequest request);


    @ApiOperation(value = "操作用户组与角色关联信息", notes = "", response = MsOperateUserGroupRelRoleResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "user_group", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateUserGroupRelRoleResponse.class) })
    @RequestMapping(value = "/userGroup/role",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateUserGroupRelRoleResponse operateUserGroupRelRole(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateUserGroupRelRoleRequest request);


    @ApiOperation(value = "操作用户组与用户关联信息", notes = "", response = MsOperateUserGroupRelUserResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "user_group", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateUserGroupRelUserResponse.class) })
    @RequestMapping(value = "/userGroup/user",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateUserGroupRelUserResponse operateUserGroupRelUser(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateUserGroupRelUserRequest request);

}
