package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * url和项目归属关系
 */
@ApiModel(description = "url和项目归属关系")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsApiUrlBelongToModel {
  @JsonProperty("resourcePlatForm")
  private Integer resourcePlatForm = null;

  @JsonProperty("resourceCode")
  private String resourceCode = null;

  @JsonProperty("resouceApiUrls")
  private List<String> resouceApiUrls = new ArrayList<String>();

  @JsonIgnore
  public MsApiUrlBelongToModel resourcePlatForm(Integer resourcePlatForm) {
    this.resourcePlatForm = resourcePlatForm;
    return this;
  }

   /**
   * 资源/url归属
   * @return resourcePlatForm
  **/
  @ApiModelProperty(value = "资源/url归属")
  public Integer getResourcePlatForm() {
    return resourcePlatForm;
  }

  public void setResourcePlatForm(Integer resourcePlatForm) {
    this.resourcePlatForm = resourcePlatForm;
  }

  @JsonIgnore
  public MsApiUrlBelongToModel resourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
    return this;
  }

   /**
   * 资源码
   * @return resourceCode
  **/
  @ApiModelProperty(value = "资源码")
  public String getResourceCode() {
    return resourceCode;
  }

  public void setResourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
  }

  @JsonIgnore
  public MsApiUrlBelongToModel resouceApiUrls(List<String> resouceApiUrls) {
    this.resouceApiUrls = resouceApiUrls;
    return this;
  }

  public MsApiUrlBelongToModel addResouceApiUrlsItem(String resouceApiUrlsItem) {
    this.resouceApiUrls.add(resouceApiUrlsItem);
    return this;
  }

   /**
   * 资源码对应的urls
   * @return resouceApiUrls
  **/
  @ApiModelProperty(value = "资源码对应的urls")
  public List<String> getResouceApiUrls() {
    return resouceApiUrls;
  }

  public void setResouceApiUrls(List<String> resouceApiUrls) {
    this.resouceApiUrls = resouceApiUrls;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsApiUrlBelongToModel apiUrlBelongToModel = (MsApiUrlBelongToModel) o;
    return Objects.equals(this.resourcePlatForm, apiUrlBelongToModel.resourcePlatForm) &&
        Objects.equals(this.resourceCode, apiUrlBelongToModel.resourceCode) &&
        Objects.equals(this.resouceApiUrls, apiUrlBelongToModel.resouceApiUrls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourcePlatForm, resourceCode, resouceApiUrls);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsApiUrlBelongToModel {\n");
    
    sb.append("    resourcePlatForm: ").append(toIndentedString(resourcePlatForm)).append("\n");
    sb.append("    resourceCode: ").append(toIndentedString(resourceCode)).append("\n");
    sb.append("    resouceApiUrls: ").append(toIndentedString(resouceApiUrls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
