package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsCheckExistsResourceRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("appId")
  private Integer appId = null;

  @JsonProperty("resourceCodes")
  private List<String> resourceCodes = new ArrayList<String>();

  @JsonIgnore
  public MsCheckExistsResourceRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsCheckExistsResourceRequest appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * appId
   * @return appId
  **/
  @ApiModelProperty(value = "appId")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsCheckExistsResourceRequest resourceCodes(List<String> resourceCodes) {
    this.resourceCodes = resourceCodes;
    return this;
  }

  public MsCheckExistsResourceRequest addResourceCodesItem(String resourceCodesItem) {
    this.resourceCodes.add(resourceCodesItem);
    return this;
  }

   /**
   * 资源码列表
   * @return resourceCodes
  **/
  @ApiModelProperty(value = "资源码列表")
  public List<String> getResourceCodes() {
    return resourceCodes;
  }

  public void setResourceCodes(List<String> resourceCodes) {
    this.resourceCodes = resourceCodes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCheckExistsResourceRequest checkExistsResourceRequest = (MsCheckExistsResourceRequest) o;
    return Objects.equals(this.userId, checkExistsResourceRequest.userId) &&
        Objects.equals(this.appId, checkExistsResourceRequest.appId) &&
        Objects.equals(this.resourceCodes, checkExistsResourceRequest.resourceCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, appId, resourceCodes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCheckExistsResourceRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    resourceCodes: ").append(toIndentedString(resourceCodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
