package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsCheckMenuNameRequest {
  @JsonProperty("menuName")
  private String menuName = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("menuId")
  private Long menuId = null;

  @JsonIgnore
  public MsCheckMenuNameRequest menuName(String menuName) {
    this.menuName = menuName;
    return this;
  }

   /**
   * 菜单名称
   * @return menuName
  **/
  @ApiModelProperty(value = "菜单名称")
  public String getMenuName() {
    return menuName;
  }

  public void setMenuName(String menuName) {
    this.menuName = menuName;
  }

  @JsonIgnore
  public MsCheckMenuNameRequest parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父菜单ID
   * @return parentId
  **/
  @ApiModelProperty(value = "父菜单ID")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsCheckMenuNameRequest menuId(Long menuId) {
    this.menuId = menuId;
    return this;
  }

   /**
   * 菜单ID
   * @return menuId
  **/
  @ApiModelProperty(value = "菜单ID")
  public Long getMenuId() {
    return menuId;
  }

  public void setMenuId(Long menuId) {
    this.menuId = menuId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCheckMenuNameRequest checkMenuNameRequest = (MsCheckMenuNameRequest) o;
    return Objects.equals(this.menuName, checkMenuNameRequest.menuName) &&
        Objects.equals(this.parentId, checkMenuNameRequest.parentId) &&
        Objects.equals(this.menuId, checkMenuNameRequest.menuId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(menuName, parentId, menuId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCheckMenuNameRequest {\n");
    
    sb.append("    menuName: ").append(toIndentedString(menuName)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    menuId: ").append(toIndentedString(menuId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
