package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetAccountDetailRequest {
  @JsonProperty("account_id")
  private Long accountId = null;

  @JsonProperty("telPhone")
  private String telPhone = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("emailOrPhone")
  private String emailOrPhone = null;

  @JsonIgnore
  public MsGetAccountDetailRequest accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * ID
   * @return accountId
  **/
  @ApiModelProperty(value = "ID")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  @JsonIgnore
  public MsGetAccountDetailRequest telPhone(String telPhone) {
    this.telPhone = telPhone;
    return this;
  }

   /**
   * 手机号码
   * @return telPhone
  **/
  @ApiModelProperty(value = "手机号码")
  public String getTelPhone() {
    return telPhone;
  }

  public void setTelPhone(String telPhone) {
    this.telPhone = telPhone;
  }

  @JsonIgnore
  public MsGetAccountDetailRequest email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 邮箱
   * @return email
  **/
  @ApiModelProperty(value = "邮箱")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsGetAccountDetailRequest emailOrPhone(String emailOrPhone) {
    this.emailOrPhone = emailOrPhone;
    return this;
  }

   /**
   * 邮箱
   * @return emailOrPhone
  **/
  @ApiModelProperty(value = "邮箱")
  public String getEmailOrPhone() {
    return emailOrPhone;
  }

  public void setEmailOrPhone(String emailOrPhone) {
    this.emailOrPhone = emailOrPhone;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetAccountDetailRequest getAccountDetailRequest = (MsGetAccountDetailRequest) o;
    return Objects.equals(this.accountId, getAccountDetailRequest.accountId) &&
        Objects.equals(this.telPhone, getAccountDetailRequest.telPhone) &&
        Objects.equals(this.email, getAccountDetailRequest.email) &&
        Objects.equals(this.emailOrPhone, getAccountDetailRequest.emailOrPhone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, telPhone, email, emailOrPhone);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetAccountDetailRequest {\n");
    
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    telPhone: ").append(toIndentedString(telPhone)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    emailOrPhone: ").append(toIndentedString(emailOrPhone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
