package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetApiUrlListRequest {
/**
 * 操作类型 USERID根据用户id获取apis RESOURCESETIDS根据功能集ids查询apis SUPERROLE 根据超级管理员角色Id查询apis
 */
  public enum DoTypeEnum {
    USERID,
    RESOURCESETIDS,
    SUPERROLE
  }
  @JsonProperty("doType")
  private DoTypeEnum doType = null;

  @JsonProperty("roleId")
  private Long roleId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("resourceSetIds")
  private List<Long> resourceSetIds = new ArrayList<Long>();

  @JsonIgnore
  public MsGetApiUrlListRequest doType(DoTypeEnum doType) {
    this.doType = doType;
    return this;
  }

   /**
   * 操作类型 USERID根据用户id获取apis RESOURCESETIDS根据功能集ids查询apis SUPERROLE 根据超级管理员角色Id查询apis
   * @return doType
  **/
  @ApiModelProperty(value = "操作类型 USERID根据用户id获取apis RESOURCESETIDS根据功能集ids查询apis SUPERROLE 根据超级管理员角色Id查询apis")
  public DoTypeEnum getDoType() {
    return doType;
  }

  public void setDoType(DoTypeEnum doType) {
    this.doType = doType;
  }

  @JsonIgnore
  public MsGetApiUrlListRequest roleId(Long roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色id
   * @return roleId
  **/
  @ApiModelProperty(value = "角色id")
  public Long getRoleId() {
    return roleId;
  }

  public void setRoleId(Long roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsGetApiUrlListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetApiUrlListRequest resourceSetIds(List<Long> resourceSetIds) {
    this.resourceSetIds = resourceSetIds;
    return this;
  }

  public MsGetApiUrlListRequest addResourceSetIdsItem(Long resourceSetIdsItem) {
    this.resourceSetIds.add(resourceSetIdsItem);
    return this;
  }

   /**
   * 功能集Id集合
   * @return resourceSetIds
  **/
  @ApiModelProperty(value = "功能集Id集合")
  public List<Long> getResourceSetIds() {
    return resourceSetIds;
  }

  public void setResourceSetIds(List<Long> resourceSetIds) {
    this.resourceSetIds = resourceSetIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetApiUrlListRequest getApiUrlListRequest = (MsGetApiUrlListRequest) o;
    return Objects.equals(this.doType, getApiUrlListRequest.doType) &&
        Objects.equals(this.roleId, getApiUrlListRequest.roleId) &&
        Objects.equals(this.userId, getApiUrlListRequest.userId) &&
        Objects.equals(this.resourceSetIds, getApiUrlListRequest.resourceSetIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(doType, roleId, userId, resourceSetIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetApiUrlListRequest {\n");
    
    sb.append("    doType: ").append(toIndentedString(doType)).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    resourceSetIds: ").append(toIndentedString(resourceSetIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
