package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetLogListRequest {
  @JsonProperty("logType")
  private String logType = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("typeId")
  private String typeId = null;

  @JsonProperty("operateName")
  private String operateName = null;

  @JsonProperty("doType")
  private String doType = null;

  @JsonProperty("startDate")
  private String startDate = null;

  @JsonProperty("endDate")
  private String endDate = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetLogListRequest logType(String logType) {
    this.logType = logType;
    return this;
  }

   /**
   * 日志类型
   * @return logType
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "日志类型")
  public String getLogType() {
    return logType;
  }

  public void setLogType(String logType) {
    this.logType = logType;
  }

  @JsonIgnore
  public MsGetLogListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetLogListRequest typeId(String typeId) {
    this.typeId = typeId;
    return this;
  }

   /**
   * 业务主键ID
   * @return typeId
  **/
  @ApiModelProperty(value = "业务主键ID")
  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  @JsonIgnore
  public MsGetLogListRequest operateName(String operateName) {
    this.operateName = operateName;
    return this;
  }

   /**
   * 操作人
   * @return operateName
  **/
  @ApiModelProperty(value = "操作人")
  public String getOperateName() {
    return operateName;
  }

  public void setOperateName(String operateName) {
    this.operateName = operateName;
  }

  @JsonIgnore
  public MsGetLogListRequest doType(String doType) {
    this.doType = doType;
    return this;
  }

   /**
   * 操作类型
   * @return doType
  **/
  @ApiModelProperty(value = "操作类型")
  public String getDoType() {
    return doType;
  }

  public void setDoType(String doType) {
    this.doType = doType;
  }

  @JsonIgnore
  public MsGetLogListRequest startDate(String startDate) {
    this.startDate = startDate;
    return this;
  }

   /**
   * 起始日期
   * @return startDate
  **/
  @ApiModelProperty(value = "起始日期")
  public String getStartDate() {
    return startDate;
  }

  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  @JsonIgnore
  public MsGetLogListRequest endDate(String endDate) {
    this.endDate = endDate;
    return this;
  }

   /**
   * 截至日期
   * @return endDate
  **/
  @ApiModelProperty(value = "截至日期")
  public String getEndDate() {
    return endDate;
  }

  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  @JsonIgnore
  public MsGetLogListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetLogListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetLogListRequest getLogListRequest = (MsGetLogListRequest) o;
    return Objects.equals(this.logType, getLogListRequest.logType) &&
        Objects.equals(this.tenantId, getLogListRequest.tenantId) &&
        Objects.equals(this.typeId, getLogListRequest.typeId) &&
        Objects.equals(this.operateName, getLogListRequest.operateName) &&
        Objects.equals(this.doType, getLogListRequest.doType) &&
        Objects.equals(this.startDate, getLogListRequest.startDate) &&
        Objects.equals(this.endDate, getLogListRequest.endDate) &&
        Objects.equals(this.page, getLogListRequest.page) &&
        Objects.equals(this.row, getLogListRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(logType, tenantId, typeId, operateName, doType, startDate, endDate, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetLogListRequest {\n");
    
    sb.append("    logType: ").append(toIndentedString(logType)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    typeId: ").append(toIndentedString(typeId)).append("\n");
    sb.append("    operateName: ").append(toIndentedString(operateName)).append("\n");
    sb.append("    doType: ").append(toIndentedString(doType)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
