package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetMenuResourceListByUserRequest {
  @JsonProperty("userId")
  private String userId = null;

  @JsonProperty("roleId")
  private String roleId = null;

  @JsonProperty("resourcesetIds")
  private List<Long> resourcesetIds = new ArrayList<Long>();

  @JsonIgnore
  public MsGetMenuResourceListByUserRequest userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户Id
   * @return userId
  **/
  @ApiModelProperty(value = "用户Id")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetMenuResourceListByUserRequest roleId(String roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色Id
   * @return roleId
  **/
  @ApiModelProperty(value = "角色Id")
  public String getRoleId() {
    return roleId;
  }

  public void setRoleId(String roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsGetMenuResourceListByUserRequest resourcesetIds(List<Long> resourcesetIds) {
    this.resourcesetIds = resourcesetIds;
    return this;
  }

  public MsGetMenuResourceListByUserRequest addResourcesetIdsItem(Long resourcesetIdsItem) {
    this.resourcesetIds.add(resourcesetIdsItem);
    return this;
  }

   /**
   * 功能集Id
   * @return resourcesetIds
  **/
  @ApiModelProperty(value = "功能集Id")
  public List<Long> getResourcesetIds() {
    return resourcesetIds;
  }

  public void setResourcesetIds(List<Long> resourcesetIds) {
    this.resourcesetIds = resourcesetIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetMenuResourceListByUserRequest getMenuResourceListByUserRequest = (MsGetMenuResourceListByUserRequest) o;
    return Objects.equals(this.userId, getMenuResourceListByUserRequest.userId) &&
        Objects.equals(this.roleId, getMenuResourceListByUserRequest.roleId) &&
        Objects.equals(this.resourcesetIds, getMenuResourceListByUserRequest.resourcesetIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, roleId, resourcesetIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetMenuResourceListByUserRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    resourcesetIds: ").append(toIndentedString(resourcesetIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
