package com.xforceplus.ucenter.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetMultiServiceApiListRequest {
  @JsonProperty("appId")
  private Long appId = null;

  @JsonProperty("serviceApiName")
  private String serviceApiName = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetMultiServiceApiListRequest appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * appId
   * @return appId
  **/
  @ApiModelProperty(value = "appId")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsGetMultiServiceApiListRequest serviceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
    return this;
  }

   /**
   * api名称
   * @return serviceApiName
  **/
  @ApiModelProperty(value = "api名称")
  public String getServiceApiName() {
    return serviceApiName;
  }

  public void setServiceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
  }

  @JsonIgnore
  public MsGetMultiServiceApiListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetMultiServiceApiListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetMultiServiceApiListRequest getSameServiceApiListRequest = (MsGetMultiServiceApiListRequest) o;
    return Objects.equals(this.appId, getSameServiceApiListRequest.appId) &&
        Objects.equals(this.serviceApiName, getSameServiceApiListRequest.serviceApiName) &&
        Objects.equals(this.page, getSameServiceApiListRequest.page) &&
        Objects.equals(this.row, getSameServiceApiListRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, serviceApiName, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetSameServiceApiListRequest {\n");

    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    serviceApiName: ").append(toIndentedString(serviceApiName)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
