package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetOrgStructListRequest {
  @JsonProperty("orgCodeName")
  private String orgCodeName = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("queryBelongToCountFlag")
  private Boolean queryBelongToCountFlag = null;

  @JsonProperty("orgType")
  private Integer orgType = null;

  @JsonProperty("singleOrgType")
  private Integer singleOrgType = null;

  @JsonProperty("auditStatus")
  private Integer auditStatus = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("excludeCurrAndSubsByOrgStructId")
  private Long excludeCurrAndSubsByOrgStructId = null;

  @JsonProperty("excludeCompanyId")
  private Long excludeCompanyId = null;

  @JsonProperty("orgStructIds")
  private List<Long> orgStructIds = new ArrayList<Long>();

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("tenantIds")
  private List<Long> tenantIds = new ArrayList<Long>();

  @JsonProperty("parentIdsList")
  private List<String> parentIdsList = new ArrayList<String>();

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonProperty("orgCodes")
  private List<String> orgCodes = new ArrayList<String>();

  @JsonProperty("companyNo")
  private String companyNo = null;

  @JsonIgnore
  public MsGetOrgStructListRequest orgCodeName(String orgCodeName) {
    this.orgCodeName = orgCodeName;
    return this;
  }

   /**
   * 组织代码名称
   * @return orgCodeName
  **/
  @ApiModelProperty(value = "组织代码名称")
  public String getOrgCodeName() {
    return orgCodeName;
  }

  public void setOrgCodeName(String orgCodeName) {
    this.orgCodeName = orgCodeName;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态
   * @return status
  **/
  @ApiModelProperty(value = "状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest queryBelongToCountFlag(Boolean queryBelongToCountFlag) {
    this.queryBelongToCountFlag = queryBelongToCountFlag;
    return this;
  }

   /**
   * 是否查询下属人数
   * @return queryBelongToCountFlag
  **/
  @ApiModelProperty(value = "是否查询下属人数")
  public Boolean getQueryBelongToCountFlag() {
    return queryBelongToCountFlag;
  }

  public void setQueryBelongToCountFlag(Boolean queryBelongToCountFlag) {
    this.queryBelongToCountFlag = queryBelongToCountFlag;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest orgType(Integer orgType) {
    this.orgType = orgType;
    return this;
  }

   /**
   * 组织类型-微服务用于多个过滤(组织类型 0；集团 1：公司 2：其他组织)
   * @return orgType
  **/
  @ApiModelProperty(value = "组织类型-微服务用于多个过滤(组织类型 0；集团 1：公司 2：其他组织)")
  public Integer getOrgType() {
    return orgType;
  }

  public void setOrgType(Integer orgType) {
    this.orgType = orgType;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest singleOrgType(Integer singleOrgType) {
    this.singleOrgType = singleOrgType;
    return this;
  }

   /**
   * 组织类型-用于微服务单个过滤(组织类型 0；集团 1：公司 2：其他组织)
   * @return singleOrgType
  **/
  @ApiModelProperty(value = "组织类型-用于微服务单个过滤(组织类型 0；集团 1：公司 2：其他组织)")
  public Integer getSingleOrgType() {
    return singleOrgType;
  }

  public void setSingleOrgType(Integer singleOrgType) {
    this.singleOrgType = singleOrgType;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest auditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

   /**
   * 公司审核状态：0待审核，1审核通过,2审核拒绝
   * @return auditStatus
  **/
  @ApiModelProperty(value = "公司审核状态：0待审核，1审核通过,2审核拒绝")
  public Integer getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest excludeCurrAndSubsByOrgStructId(Long excludeCurrAndSubsByOrgStructId) {
    this.excludeCurrAndSubsByOrgStructId = excludeCurrAndSubsByOrgStructId;
    return this;
  }

   /**
   * 查询排除当前节点及以下节点id集合
   * @return excludeCurrAndSubsByOrgStructId
  **/
  @ApiModelProperty(value = "查询排除当前节点及以下节点id集合")
  public Long getExcludeCurrAndSubsByOrgStructId() {
    return excludeCurrAndSubsByOrgStructId;
  }

  public void setExcludeCurrAndSubsByOrgStructId(Long excludeCurrAndSubsByOrgStructId) {
    this.excludeCurrAndSubsByOrgStructId = excludeCurrAndSubsByOrgStructId;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest excludeCompanyId(Long excludeCompanyId) {
    this.excludeCompanyId = excludeCompanyId;
    return this;
  }

   /**
   * 查询排除公司id
   * @return excludeCompanyId
  **/
  @ApiModelProperty(value = "查询排除公司id")
  public Long getExcludeCompanyId() {
    return excludeCompanyId;
  }

  public void setExcludeCompanyId(Long excludeCompanyId) {
    this.excludeCompanyId = excludeCompanyId;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest orgStructIds(List<Long> orgStructIds) {
    this.orgStructIds = orgStructIds;
    return this;
  }

  public MsGetOrgStructListRequest addOrgStructIdsItem(Long orgStructIdsItem) {
    this.orgStructIds.add(orgStructIdsItem);
    return this;
  }

   /**
   * 组织机构id集合
   * @return orgStructIds
  **/
  @ApiModelProperty(value = "组织机构id集合")
  public List<Long> getOrgStructIds() {
    return orgStructIds;
  }

  public void setOrgStructIds(List<Long> orgStructIds) {
    this.orgStructIds = orgStructIds;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父节点id
   * @return parentId
  **/
  @ApiModelProperty(value = "父节点id")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest tenantIds(List<Long> tenantIds) {
    this.tenantIds = tenantIds;
    return this;
  }

  public MsGetOrgStructListRequest addTenantIdsItem(Long tenantIdsItem) {
    this.tenantIds.add(tenantIdsItem);
    return this;
  }

   /**
   * 租户id集合
   * @return tenantIds
  **/
  @ApiModelProperty(value = "租户id集合")
  public List<Long> getTenantIds() {
    return tenantIds;
  }

  public void setTenantIds(List<Long> tenantIds) {
    this.tenantIds = tenantIds;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest parentIdsList(List<String> parentIdsList) {
    this.parentIdsList = parentIdsList;
    return this;
  }

  public MsGetOrgStructListRequest addParentIdsListItem(String parentIdsListItem) {
    this.parentIdsList.add(parentIdsListItem);
    return this;
  }

   /**
   * 父组织ids集合
   * @return parentIdsList
  **/
  @ApiModelProperty(value = "父组织ids集合")
  public List<String> getParentIdsList() {
    return parentIdsList;
  }

  public void setParentIdsList(List<String> parentIdsList) {
    this.parentIdsList = parentIdsList;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }

  @JsonIgnore
  public MsGetOrgStructListRequest orgCodes(List<String> orgCodes) {
    this.orgCodes = orgCodes;
    return this;
  }

  public MsGetOrgStructListRequest addOrgCodesItem(String orgCodesItem) {
    this.orgCodes.add(orgCodesItem);
    return this;
  }

   /**
   * 组织编码集合
   * @return orgCodes
  **/
  @ApiModelProperty(value = "组织编码集合")
  public List<String> getOrgCodes() {
    return orgCodes;
  }

  public void setOrgCodes(List<String> orgCodes) {
    this.orgCodes = orgCodes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOrgStructListRequest getOrgStructListRequest = (MsGetOrgStructListRequest) o;
    return Objects.equals(this.orgCodeName, getOrgStructListRequest.orgCodeName) &&
        Objects.equals(this.status, getOrgStructListRequest.status) &&
        Objects.equals(this.statusTime, getOrgStructListRequest.statusTime) &&
        Objects.equals(this.queryBelongToCountFlag, getOrgStructListRequest.queryBelongToCountFlag) &&
        Objects.equals(this.orgType, getOrgStructListRequest.orgType) &&
        Objects.equals(this.singleOrgType, getOrgStructListRequest.singleOrgType) &&
        Objects.equals(this.auditStatus, getOrgStructListRequest.auditStatus) &&
        Objects.equals(this.tenantId, getOrgStructListRequest.tenantId) &&
        Objects.equals(this.userId, getOrgStructListRequest.userId) &&
        Objects.equals(this.excludeCurrAndSubsByOrgStructId, getOrgStructListRequest.excludeCurrAndSubsByOrgStructId) &&
        Objects.equals(this.excludeCompanyId, getOrgStructListRequest.excludeCompanyId) &&
        Objects.equals(this.orgStructIds, getOrgStructListRequest.orgStructIds) &&
        Objects.equals(this.parentId, getOrgStructListRequest.parentId) &&
        Objects.equals(this.tenantIds, getOrgStructListRequest.tenantIds) &&
        Objects.equals(this.parentIdsList, getOrgStructListRequest.parentIdsList) &&
        Objects.equals(this.page, getOrgStructListRequest.page) &&
        Objects.equals(this.row, getOrgStructListRequest.row) &&
        Objects.equals(this.orgCodes, getOrgStructListRequest.orgCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgCodeName, status, statusTime, queryBelongToCountFlag, orgType, singleOrgType, auditStatus, tenantId, userId, excludeCurrAndSubsByOrgStructId, excludeCompanyId, orgStructIds, parentId, tenantIds, parentIdsList, page, row, orgCodes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOrgStructListRequest {\n");
    
    sb.append("    orgCodeName: ").append(toIndentedString(orgCodeName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    queryBelongToCountFlag: ").append(toIndentedString(queryBelongToCountFlag)).append("\n");
    sb.append("    orgType: ").append(toIndentedString(orgType)).append("\n");
    sb.append("    singleOrgType: ").append(toIndentedString(singleOrgType)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    excludeCurrAndSubsByOrgStructId: ").append(toIndentedString(excludeCurrAndSubsByOrgStructId)).append("\n");
    sb.append("    excludeCompanyId: ").append(toIndentedString(excludeCompanyId)).append("\n");
    sb.append("    orgStructIds: ").append(toIndentedString(orgStructIds)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("    parentIdsList: ").append(toIndentedString(parentIdsList)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("    orgCodes: ").append(toIndentedString(orgCodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public String getCompanyNo() {
    return companyNo;
  }

  public void setCompanyNo(String companyNo) {
    this.companyNo = companyNo;
  }
}
