package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetOrgSubListRequest {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("orgStructId")
  private Long orgStructId = null;

  @JsonIgnore
  public MsGetOrgSubListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGetOrgSubListRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsGetOrgSubListRequest orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * 组织名称
   * @return orgName
  **/
  @ApiModelProperty(value = "组织名称")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public MsGetOrgSubListRequest orgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * 当前节点id
   * @return orgStructId
  **/
  @ApiModelProperty(value = "当前节点id")
  public Long getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOrgSubListRequest getOrgSubListRequest = (MsGetOrgSubListRequest) o;
    return Objects.equals(this.tenantId, getOrgSubListRequest.tenantId) &&
        Objects.equals(this.companyId, getOrgSubListRequest.companyId) &&
        Objects.equals(this.orgName, getOrgSubListRequest.orgName) &&
        Objects.equals(this.orgStructId, getOrgSubListRequest.orgStructId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, companyId, orgName, orgStructId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOrgSubListRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
