package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetOrgUserRelListRequest {
  @JsonProperty("relId")
  private Long relId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("orgStructId")
  private Long orgStructId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsGetOrgUserRelListRequest relId(Long relId) {
    this.relId = relId;
    return this;
  }

   /**
   * 主键id
   * @return relId
  **/
  @ApiModelProperty(value = "主键id")
  public Long getRelId() {
    return relId;
  }

  public void setRelId(Long relId) {
    this.relId = relId;
  }

  @JsonIgnore
  public MsGetOrgUserRelListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 人员id
   * @return userId
  **/
  @ApiModelProperty(value = "人员id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetOrgUserRelListRequest orgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * 组织id
   * @return orgStructId
  **/
  @ApiModelProperty(value = "组织id")
  public Long getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
  }

  @JsonIgnore
  public MsGetOrgUserRelListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetOrgUserRelListRequest getOrgUserRelListRequest = (MsGetOrgUserRelListRequest) o;
    return Objects.equals(this.relId, getOrgUserRelListRequest.relId) &&
        Objects.equals(this.userId, getOrgUserRelListRequest.userId) &&
        Objects.equals(this.orgStructId, getOrgUserRelListRequest.orgStructId) &&
        Objects.equals(this.tenantId, getOrgUserRelListRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(relId, userId, orgStructId, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetOrgUserRelListRequest {\n");
    
    sb.append("    relId: ").append(toIndentedString(relId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
