package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetPathsByUserIdRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("loginId")
  private String loginId = null;

  @JsonProperty("appId")
  private Integer appId = null;

  @JsonIgnore
  public MsGetPathsByUserIdRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetPathsByUserIdRequest loginId(String loginId) {
    this.loginId = loginId;
    return this;
  }

   /**
   * 登录id
   * @return loginId
  **/
  @ApiModelProperty(value = "登录id")
  public String getLoginId() {
    return loginId;
  }

  public void setLoginId(String loginId) {
    this.loginId = loginId;
  }

  @JsonIgnore
  public MsGetPathsByUserIdRequest appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * appId
   * @return appId
  **/
  @ApiModelProperty(value = "appId")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPathsByUserIdRequest getPathsByUserIdRequest = (MsGetPathsByUserIdRequest) o;
    return Objects.equals(this.userId, getPathsByUserIdRequest.userId) &&
        Objects.equals(this.loginId, getPathsByUserIdRequest.loginId) &&
        Objects.equals(this.appId, getPathsByUserIdRequest.appId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, loginId, appId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetPathsByUserIdRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    loginId: ").append(toIndentedString(loginId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
