package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ucenter.client.model.MsSysResourceApiRelDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourceApiRelListResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("result")
  private List<MsSysResourceApiRelDTO> result = new ArrayList<MsSysResourceApiRelDTO>();

  @JsonIgnore
  public MsGetResourceApiRelListResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetResourceApiRelListResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetResourceApiRelListResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * return total
   * @return total
  **/
  @ApiModelProperty(value = "return total")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsGetResourceApiRelListResponse result(List<MsSysResourceApiRelDTO> result) {
    this.result = result;
    return this;
  }

  public MsGetResourceApiRelListResponse addResultItem(MsSysResourceApiRelDTO resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 资源码-Api关联信息
   * @return result
  **/
  @ApiModelProperty(value = "资源码-Api关联信息")
  public List<MsSysResourceApiRelDTO> getResult() {
    return result;
  }

  public void setResult(List<MsSysResourceApiRelDTO> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourceApiRelListResponse getResourceApiRelListResponse = (MsGetResourceApiRelListResponse) o;
    return Objects.equals(this.code, getResourceApiRelListResponse.code) &&
        Objects.equals(this.message, getResourceApiRelListResponse.message) &&
        Objects.equals(this.total, getResourceApiRelListResponse.total) &&
        Objects.equals(this.result, getResourceApiRelListResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourceApiRelListResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
