package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourceByApiUrlRequest {
  @JsonProperty("serviceApiUrl")
  private String serviceApiUrl = null;

  @JsonIgnore
  public MsGetResourceByApiUrlRequest serviceApiUrl(String serviceApiUrl) {
    this.serviceApiUrl = serviceApiUrl;
    return this;
  }

   /**
   * 服务api Url
   * @return serviceApiUrl
  **/
  @ApiModelProperty(value = "服务api Url")
  public String getServiceApiUrl() {
    return serviceApiUrl;
  }

  public void setServiceApiUrl(String serviceApiUrl) {
    this.serviceApiUrl = serviceApiUrl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourceByApiUrlRequest getResourceByApiUrlRequest = (MsGetResourceByApiUrlRequest) o;
    return Objects.equals(this.serviceApiUrl, getResourceByApiUrlRequest.serviceApiUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serviceApiUrl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourceByApiUrlRequest {\n");
    
    sb.append("    serviceApiUrl: ").append(toIndentedString(serviceApiUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
