package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourceDetailRequest {
  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("appId")
  private Long appId = null;

  @JsonProperty("resourceName")
  private String resourceName = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("isServicePackage")
  private Integer isServicePackage = null;

  @JsonProperty("checkParamFlag")
  private Boolean checkParamFlag = null;

  @JsonProperty("resourceCode")
  private String resourceCode = null;

  @JsonIgnore
  public MsGetResourceDetailRequest resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * ID
   * @return resourceId
  **/
  @ApiModelProperty(value = "ID")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsGetResourceDetailRequest appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * appId
   * @return appId
  **/
  @ApiModelProperty(value = "appId")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsGetResourceDetailRequest resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

   /**
   * 资源码名称
   * @return resourceName
  **/
  @ApiModelProperty(value = "资源码名称")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  @JsonIgnore
  public MsGetResourceDetailRequest parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 资源码父节点id
   * @return parentId
  **/
  @ApiModelProperty(value = "资源码父节点id")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsGetResourceDetailRequest isServicePackage(Integer isServicePackage) {
    this.isServicePackage = isServicePackage;
    return this;
  }

   /**
   * 是否和服务包做交集
   * @return isServicePackage
  **/
  @ApiModelProperty(value = "是否和服务包做交集")
  public Integer getIsServicePackage() {
    return isServicePackage;
  }

  public void setIsServicePackage(Integer isServicePackage) {
    this.isServicePackage = isServicePackage;
  }

  @JsonIgnore
  public MsGetResourceDetailRequest checkParamFlag(Boolean checkParamFlag) {
    this.checkParamFlag = checkParamFlag;
    return this;
  }

   /**
   * 是否是名称/其他 参数验证
   * @return checkParamFlag
  **/
  @ApiModelProperty(value = "是否是名称/其他 参数验证")
  public Boolean getCheckParamFlag() {
    return checkParamFlag;
  }

  public void setCheckParamFlag(Boolean checkParamFlag) {
    this.checkParamFlag = checkParamFlag;
  }

  @JsonIgnore
  public MsGetResourceDetailRequest resourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
    return this;
  }

   /**
   * 资源码Code
   * @return resourceCode
  **/
  @ApiModelProperty(value = "资源码Code")
  public String getResourceCode() {
    return resourceCode;
  }

  public void setResourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourceDetailRequest getResourceDetailRequest = (MsGetResourceDetailRequest) o;
    return Objects.equals(this.resourceId, getResourceDetailRequest.resourceId) &&
        Objects.equals(this.appId, getResourceDetailRequest.appId) &&
        Objects.equals(this.resourceName, getResourceDetailRequest.resourceName) &&
        Objects.equals(this.parentId, getResourceDetailRequest.parentId) &&
        Objects.equals(this.isServicePackage, getResourceDetailRequest.isServicePackage) &&
        Objects.equals(this.checkParamFlag, getResourceDetailRequest.checkParamFlag) &&
        Objects.equals(this.resourceCode, getResourceDetailRequest.resourceCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceId, appId, resourceName, parentId, isServicePackage, checkParamFlag, resourceCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourceDetailRequest {\n");
    
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    isServicePackage: ").append(toIndentedString(isServicePackage)).append("\n");
    sb.append("    checkParamFlag: ").append(toIndentedString(checkParamFlag)).append("\n");
    sb.append("    resourceCode: ").append(toIndentedString(resourceCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
