package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourceLevelByUserIdRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("appId")
  private Integer appId = null;

  @JsonProperty("resourceName")
  private String resourceName = null;

  @JsonIgnore
  public MsGetResourceLevelByUserIdRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsGetResourceLevelByUserIdRequest appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * appId
   * @return appId
  **/
  @ApiModelProperty(value = "appId")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsGetResourceLevelByUserIdRequest resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

   /**
   * 资源码或者中文
   * @return resourceName
  **/
  @ApiModelProperty(value = "资源码或者中文")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourceLevelByUserIdRequest getResourceLevelByUserIdRequest = (MsGetResourceLevelByUserIdRequest) o;
    return Objects.equals(this.userId, getResourceLevelByUserIdRequest.userId) &&
        Objects.equals(this.appId, getResourceLevelByUserIdRequest.appId) &&
        Objects.equals(this.resourceName, getResourceLevelByUserIdRequest.resourceName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, appId, resourceName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourceLevelByUserIdRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
