package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourceListRequest {
  @JsonProperty("resourceName")
  private String resourceName = null;

  @JsonProperty("appIds")
  private List<Long> appIds = new ArrayList<Long>();

  @JsonProperty("resourceCode")
  private String resourceCode = null;

  @JsonProperty("resourceType")
  private Integer resourceType = null;

  @JsonProperty("resourcePlatform")
  private Integer resourcePlatform = null;

  @JsonProperty("isServicePackage")
  private Integer isServicePackage = null;

  @JsonProperty("querySubResourceFlag")
  private Boolean querySubResourceFlag = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetResourceListRequest resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

   /**
   * 资源码名称
   * @return resourceName
  **/
  @ApiModelProperty(value = "资源码名称")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  @JsonIgnore
  public MsGetResourceListRequest appIds(List<Long> appIds) {
    this.appIds = appIds;
    return this;
  }

  public MsGetResourceListRequest addAppIdsItem(Long appIdsItem) {
    this.appIds.add(appIdsItem);
    return this;
  }

   /**
   * 产线id
   * @return appIds
  **/
  @ApiModelProperty(value = "产线id")
  public List<Long> getAppIds() {
    return appIds;
  }

  public void setAppIds(List<Long> appIds) {
    this.appIds = appIds;
  }

  @JsonIgnore
  public MsGetResourceListRequest resourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
    return this;
  }

   /**
   * 资源码
   * @return resourceCode
  **/
  @ApiModelProperty(value = "资源码")
  public String getResourceCode() {
    return resourceCode;
  }

  public void setResourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
  }

  @JsonIgnore
  public MsGetResourceListRequest resourceType(Integer resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 资源码类型： 0:url 1:模块 2:操作 3:页面
   * @return resourceType
  **/
  @ApiModelProperty(value = "资源码类型： 0:url 1:模块 2:操作 3:页面")
  public Integer getResourceType() {
    return resourceType;
  }

  public void setResourceType(Integer resourceType) {
    this.resourceType = resourceType;
  }

  @JsonIgnore
  public MsGetResourceListRequest resourcePlatform(Integer resourcePlatform) {
    this.resourcePlatform = resourcePlatform;
    return this;
  }

   /**
   * 资源码所属平台 0:进项 1:销项 2:权限 3:公共 4:其他
   * @return resourcePlatform
  **/
  @ApiModelProperty(value = "资源码所属平台 0:进项 1:销项 2:权限 3:公共 4:其他")
  public Integer getResourcePlatform() {
    return resourcePlatform;
  }

  public void setResourcePlatform(Integer resourcePlatform) {
    this.resourcePlatform = resourcePlatform;
  }

  @JsonIgnore
  public MsGetResourceListRequest isServicePackage(Integer isServicePackage) {
    this.isServicePackage = isServicePackage;
    return this;
  }

   /**
   * 是否和服务包做交集
   * @return isServicePackage
  **/
  @ApiModelProperty(value = "是否和服务包做交集")
  public Integer getIsServicePackage() {
    return isServicePackage;
  }

  public void setIsServicePackage(Integer isServicePackage) {
    this.isServicePackage = isServicePackage;
  }

  @JsonIgnore
  public MsGetResourceListRequest querySubResourceFlag(Boolean querySubResourceFlag) {
    this.querySubResourceFlag = querySubResourceFlag;
    return this;
  }

   /**
   * 是否查询下级列表
   * @return querySubResourceFlag
  **/
  @ApiModelProperty(value = "是否查询下级列表")
  public Boolean getQuerySubResourceFlag() {
    return querySubResourceFlag;
  }

  public void setQuerySubResourceFlag(Boolean querySubResourceFlag) {
    this.querySubResourceFlag = querySubResourceFlag;
  }

  @JsonIgnore
  public MsGetResourceListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetResourceListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourceListRequest getResourceListRequest = (MsGetResourceListRequest) o;
    return Objects.equals(this.resourceName, getResourceListRequest.resourceName) &&
        Objects.equals(this.appIds, getResourceListRequest.appIds) &&
        Objects.equals(this.resourceCode, getResourceListRequest.resourceCode) &&
        Objects.equals(this.resourceType, getResourceListRequest.resourceType) &&
        Objects.equals(this.resourcePlatform, getResourceListRequest.resourcePlatform) &&
        Objects.equals(this.isServicePackage, getResourceListRequest.isServicePackage) &&
        Objects.equals(this.querySubResourceFlag, getResourceListRequest.querySubResourceFlag) &&
        Objects.equals(this.page, getResourceListRequest.page) &&
        Objects.equals(this.row, getResourceListRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceName, appIds, resourceCode, resourceType, resourcePlatform, isServicePackage, querySubResourceFlag, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourceListRequest {\n");
    
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    appIds: ").append(toIndentedString(appIds)).append("\n");
    sb.append("    resourceCode: ").append(toIndentedString(resourceCode)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourcePlatform: ").append(toIndentedString(resourcePlatform)).append("\n");
    sb.append("    isServicePackage: ").append(toIndentedString(isServicePackage)).append("\n");
    sb.append("    querySubResourceFlag: ").append(toIndentedString(querySubResourceFlag)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
