package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourcesetDetailRequest {
  @JsonProperty("resourcesetId")
  private Long resourcesetId = null;

  @JsonProperty("hasResourceList")
  private Boolean hasResourceList = null;

  @JsonIgnore
  public MsGetResourcesetDetailRequest resourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
    return this;
  }

   /**
   * ID
   * @return resourcesetId
  **/
  @ApiModelProperty(value = "ID")
  public Long getResourcesetId() {
    return resourcesetId;
  }

  public void setResourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
  }

  @JsonIgnore
  public MsGetResourcesetDetailRequest hasResourceList(Boolean hasResourceList) {
    this.hasResourceList = hasResourceList;
    return this;
  }

   /**
   * 是否包含资源码列表
   * @return hasResourceList
  **/
  @ApiModelProperty(value = "是否包含资源码列表")
  public Boolean getHasResourceList() {
    return hasResourceList;
  }

  public void setHasResourceList(Boolean hasResourceList) {
    this.hasResourceList = hasResourceList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourcesetDetailRequest getResourcesetDetailRequest = (MsGetResourcesetDetailRequest) o;
    return Objects.equals(this.resourcesetId, getResourcesetDetailRequest.resourcesetId) &&
        Objects.equals(this.hasResourceList, getResourcesetDetailRequest.hasResourceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourcesetId, hasResourceList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourcesetDetailRequest {\n");
    
    sb.append("    resourcesetId: ").append(toIndentedString(resourcesetId)).append("\n");
    sb.append("    hasResourceList: ").append(toIndentedString(hasResourceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
