package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetResourcesetListRequest {
  @JsonProperty("hasResourceList")
  private Boolean hasResourceList = null;

  @JsonProperty("resourcesetName")
  private String resourcesetName = null;

  @JsonProperty("appIds")
  private List<Long> appIds = new ArrayList<Long>();

  @JsonProperty("resourcesetIds")
  private List<Long> resourcesetIds = new ArrayList<Long>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetResourcesetListRequest hasResourceList(Boolean hasResourceList) {
    this.hasResourceList = hasResourceList;
    return this;
  }

   /**
   * 是否包含资源码列表
   * @return hasResourceList
  **/
  @ApiModelProperty(value = "是否包含资源码列表")
  public Boolean getHasResourceList() {
    return hasResourceList;
  }

  public void setHasResourceList(Boolean hasResourceList) {
    this.hasResourceList = hasResourceList;
  }

  @JsonIgnore
  public MsGetResourcesetListRequest resourcesetName(String resourcesetName) {
    this.resourcesetName = resourcesetName;
    return this;
  }

   /**
   * 功能集名称
   * @return resourcesetName
  **/
  @ApiModelProperty(value = "功能集名称")
  public String getResourcesetName() {
    return resourcesetName;
  }

  public void setResourcesetName(String resourcesetName) {
    this.resourcesetName = resourcesetName;
  }

  @JsonIgnore
  public MsGetResourcesetListRequest appIds(List<Long> appIds) {
    this.appIds = appIds;
    return this;
  }

  public MsGetResourcesetListRequest addAppIdsItem(Long appIdsItem) {
    this.appIds.add(appIdsItem);
    return this;
  }

   /**
   * 产线id
   * @return appIds
  **/
  @ApiModelProperty(value = "产线id")
  public List<Long> getAppIds() {
    return appIds;
  }

  public void setAppIds(List<Long> appIds) {
    this.appIds = appIds;
  }

  @JsonIgnore
  public MsGetResourcesetListRequest resourcesetIds(List<Long> resourcesetIds) {
    this.resourcesetIds = resourcesetIds;
    return this;
  }

  public MsGetResourcesetListRequest addResourcesetIdsItem(Long resourcesetIdsItem) {
    this.resourcesetIds.add(resourcesetIdsItem);
    return this;
  }

   /**
   * 功能集id集合
   * @return resourcesetIds
  **/
  @ApiModelProperty(value = "功能集id集合")
  public List<Long> getResourcesetIds() {
    return resourcesetIds;
  }

  public void setResourcesetIds(List<Long> resourcesetIds) {
    this.resourcesetIds = resourcesetIds;
  }

  @JsonIgnore
  public MsGetResourcesetListRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 功能集状态
   * @return status
  **/
  @ApiModelProperty(value = "功能集状态")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetResourcesetListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetResourcesetListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetResourcesetListRequest getResourcesetListRequest = (MsGetResourcesetListRequest) o;
    return Objects.equals(this.hasResourceList, getResourcesetListRequest.hasResourceList) &&
        Objects.equals(this.resourcesetName, getResourcesetListRequest.resourcesetName) &&
        Objects.equals(this.appIds, getResourcesetListRequest.appIds) &&
        Objects.equals(this.resourcesetIds, getResourcesetListRequest.resourcesetIds) &&
        Objects.equals(this.status, getResourcesetListRequest.status) &&
        Objects.equals(this.page, getResourcesetListRequest.page) &&
        Objects.equals(this.row, getResourcesetListRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hasResourceList, resourcesetName, appIds, resourcesetIds, status, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetResourcesetListRequest {\n");
    
    sb.append("    hasResourceList: ").append(toIndentedString(hasResourceList)).append("\n");
    sb.append("    resourcesetName: ").append(toIndentedString(resourcesetName)).append("\n");
    sb.append("    appIds: ").append(toIndentedString(appIds)).append("\n");
    sb.append("    resourcesetIds: ").append(toIndentedString(resourcesetIds)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
