package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRoleListByUserGroupRequest {
  @JsonProperty("roleValue")
  private String roleValue = null;

  @JsonProperty("userGroupId")
  private Long userGroupId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetRoleListByUserGroupRequest roleValue(String roleValue) {
    this.roleValue = roleValue;
    return this;
  }

   /**
   * 角色名称，代码
   * @return roleValue
  **/
  @ApiModelProperty(value = "角色名称，代码")
  public String getRoleValue() {
    return roleValue;
  }

  public void setRoleValue(String roleValue) {
    this.roleValue = roleValue;
  }

  @JsonIgnore
  public MsGetRoleListByUserGroupRequest userGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
    return this;
  }

   /**
   * 用户组id
   * @return userGroupId
  **/
  @ApiModelProperty(value = "用户组id")
  public Long getUserGroupId() {
    return userGroupId;
  }

  public void setUserGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
  }

  @JsonIgnore
  public MsGetRoleListByUserGroupRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetRoleListByUserGroupRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRoleListByUserGroupRequest getRoleListByUserGroupRequest = (MsGetRoleListByUserGroupRequest) o;
    return Objects.equals(this.roleValue, getRoleListByUserGroupRequest.roleValue) &&
        Objects.equals(this.userGroupId, getRoleListByUserGroupRequest.userGroupId) &&
        Objects.equals(this.page, getRoleListByUserGroupRequest.page) &&
        Objects.equals(this.row, getRoleListByUserGroupRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roleValue, userGroupId, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRoleListByUserGroupRequest {\n");
    
    sb.append("    roleValue: ").append(toIndentedString(roleValue)).append("\n");
    sb.append("    userGroupId: ").append(toIndentedString(userGroupId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
