package com.xforceplus.ucenter.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetServiceApiMgrListRequest {
    @JsonProperty("appId")
    private List<Long> appId = null;

    @JsonProperty("ServiceApiName")
    private String serviceApiName = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("returnResourceRelCount")
    private Boolean returnResourceRelCount = null;


    @JsonIgnore
    public MsGetServiceApiMgrListRequest serviceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
        return this;
    }

    /**
     * 服务Api名称
     *
     * @return serviceApiName
     **/
    @ApiModelProperty(value = "服务Api名称")
    public String getServiceApiName() {
        return serviceApiName;
    }

    public void setServiceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
    }

    @JsonIgnore
    public MsGetServiceApiMgrListRequest page(Integer page) {
        this.page = page;
        return this;
    }

    /**
     * 当前页
     *
     * @return page
     **/
    @ApiModelProperty(value = "当前页")
    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    @JsonIgnore
    public MsGetServiceApiMgrListRequest row(Integer row) {
        this.row = row;
        return this;
    }

    /**
     * 每页显示行数
     *
     * @return row
     **/
    @ApiModelProperty(value = "每页显示行数")
    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    @JsonIgnore
    public MsGetServiceApiMgrListRequest returnResourceRelCount(Boolean returnResourceRelCount) {
        this.returnResourceRelCount = returnResourceRelCount;
        return this;
    }

    /**
     * returnResourceRelCount
     *
     * @return returnResourceRelCount
     **/
    @ApiModelProperty(value = "returnResourceRelCount")
    public Boolean getReturnResourceRelCount() {
        return returnResourceRelCount;
    }

    public void setReturnResourceRelCount(Boolean returnResourceRelCount) {
        this.returnResourceRelCount = returnResourceRelCount;
    }

    public List<Long> getAppId() {
        return appId;
    }

    public void setAppId(List<Long> appId) {
        this.appId = appId;
    }
}
