package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetUserListByUserGroupRequest {
  @JsonProperty("userValue")
  private String userValue = null;

  @JsonProperty("userGroupId")
  private Long userGroupId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("row")
  private Integer row = null;

  @JsonIgnore
  public MsGetUserListByUserGroupRequest userValue(String userValue) {
    this.userValue = userValue;
    return this;
  }

   /**
   * 人员代码/人员工号/人员名称
   * @return userValue
  **/
  @ApiModelProperty(value = "人员代码/人员工号/人员名称")
  public String getUserValue() {
    return userValue;
  }

  public void setUserValue(String userValue) {
    this.userValue = userValue;
  }

  @JsonIgnore
  public MsGetUserListByUserGroupRequest userGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
    return this;
  }

   /**
   * 用户组id
   * @return userGroupId
  **/
  @ApiModelProperty(value = "用户组id")
  public Long getUserGroupId() {
    return userGroupId;
  }

  public void setUserGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
  }

  @JsonIgnore
  public MsGetUserListByUserGroupRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  @JsonIgnore
  public MsGetUserListByUserGroupRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")
  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetUserListByUserGroupRequest getUserListByUserGroupRequest = (MsGetUserListByUserGroupRequest) o;
    return Objects.equals(this.userValue, getUserListByUserGroupRequest.userValue) &&
        Objects.equals(this.userGroupId, getUserListByUserGroupRequest.userGroupId) &&
        Objects.equals(this.page, getUserListByUserGroupRequest.page) &&
        Objects.equals(this.row, getUserListByUserGroupRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userValue, userGroupId, page, row);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetUserListByUserGroupRequest {\n");
    
    sb.append("    userValue: ").append(toIndentedString(userValue)).append("\n");
    sb.append("    userGroupId: ").append(toIndentedString(userGroupId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
