package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoBase;
import com.xforceplus.ucenter.client.model.MsSysUserDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateOpenApiUserRequest extends MsDoBase {
  @JsonProperty("OpenApiUserInfo")
  private MsSysUserDTO openApiUserInfo = null;

  @JsonIgnore
  public MsOperateOpenApiUserRequest openApiUserInfo(MsSysUserDTO openApiUserInfo) {
    this.openApiUserInfo = openApiUserInfo;
    return this;
  }

   /**
   * Get openApiUserInfo
   * @return openApiUserInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysUserDTO getOpenApiUserInfo() {
    return openApiUserInfo;
  }

  public void setOpenApiUserInfo(MsSysUserDTO openApiUserInfo) {
    this.openApiUserInfo = openApiUserInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateOpenApiUserRequest operateOpenApiUserRequest = (MsOperateOpenApiUserRequest) o;
    return Objects.equals(this.openApiUserInfo, operateOpenApiUserRequest.openApiUserInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(openApiUserInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateOpenApiUserRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    openApiUserInfo: ").append(toIndentedString(openApiUserInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
