package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoID;
import com.xforceplus.ucenter.client.model.MsSysOrgUserRelDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 操作人员角色关联信息
 */
@ApiModel(description = "操作人员角色关联信息")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateOrgUserRelRequest extends MsDoID {
  @JsonProperty("orgUserRelInfo")
  private MsSysOrgUserRelDTO orgUserRelInfo = null;

/**
 * 操作类型
 */
  public enum DeleteTypeEnum {
    RELID,
    USERID,
    ORGSTRUCTID
  }
  @JsonProperty("deleteType")
  private DeleteTypeEnum deleteType = null;

  @JsonProperty("value")
  private Long value = null;

  @JsonIgnore
  public MsOperateOrgUserRelRequest orgUserRelInfo(MsSysOrgUserRelDTO orgUserRelInfo) {
    this.orgUserRelInfo = orgUserRelInfo;
    return this;
  }

   /**
   * Get orgUserRelInfo
   * @return orgUserRelInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysOrgUserRelDTO getOrgUserRelInfo() {
    return orgUserRelInfo;
  }

  public void setOrgUserRelInfo(MsSysOrgUserRelDTO orgUserRelInfo) {
    this.orgUserRelInfo = orgUserRelInfo;
  }

  @JsonIgnore
  public MsOperateOrgUserRelRequest deleteType(DeleteTypeEnum deleteType) {
    this.deleteType = deleteType;
    return this;
  }

   /**
   * 操作类型
   * @return deleteType
  **/
  @ApiModelProperty(value = "操作类型")
  public DeleteTypeEnum getDeleteType() {
    return deleteType;
  }

  public void setDeleteType(DeleteTypeEnum deleteType) {
    this.deleteType = deleteType;
  }

  @JsonIgnore
  public MsOperateOrgUserRelRequest value(Long value) {
    this.value = value;
    return this;
  }

   /**
   * 删除值
   * @return value
  **/
  @ApiModelProperty(value = "删除值")
  public Long getValue() {
    return value;
  }

  public void setValue(Long value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateOrgUserRelRequest operateOrgUserRelRequest = (MsOperateOrgUserRelRequest) o;
    return Objects.equals(this.orgUserRelInfo, operateOrgUserRelRequest.orgUserRelInfo) &&
        Objects.equals(this.deleteType, operateOrgUserRelRequest.deleteType) &&
        Objects.equals(this.value, operateOrgUserRelRequest.value) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgUserRelInfo, deleteType, value, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateOrgUserRelRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    orgUserRelInfo: ").append(toIndentedString(orgUserRelInfo)).append("\n");
    sb.append("    deleteType: ").append(toIndentedString(deleteType)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
