package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoIUSNFD;
import com.xforceplus.ucenter.client.model.MsResourcesetDtoExt;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateResourcesetRequest extends MsDoIUSNFD {
  @JsonProperty("resourcesetInfo")
  private MsResourcesetDtoExt resourcesetInfo = null;

  @JsonIgnore
  public MsOperateResourcesetRequest resourcesetInfo(MsResourcesetDtoExt resourcesetInfo) {
    this.resourcesetInfo = resourcesetInfo;
    return this;
  }

   /**
   * Get resourcesetInfo
   * @return resourcesetInfo
  **/
  @ApiModelProperty(value = "")
  public MsResourcesetDtoExt getResourcesetInfo() {
    return resourcesetInfo;
  }

  public void setResourcesetInfo(MsResourcesetDtoExt resourcesetInfo) {
    this.resourcesetInfo = resourcesetInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateResourcesetRequest operateResourcesetRequest = (MsOperateResourcesetRequest) o;
    return Objects.equals(this.resourcesetInfo, operateResourcesetRequest.resourcesetInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourcesetInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateResourcesetRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    resourcesetInfo: ").append(toIndentedString(resourcesetInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
