package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoIU;
import com.xforceplus.ucenter.client.model.MsSysRoleResourcesetRelDTOExt;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateRoleResourcesetRelRequest extends MsDoIU {
  @JsonProperty("roleResourcesetRelInfoExt")
  private MsSysRoleResourcesetRelDTOExt roleResourcesetRelInfoExt = null;

  @JsonIgnore
  public MsOperateRoleResourcesetRelRequest roleResourcesetRelInfoExt(MsSysRoleResourcesetRelDTOExt roleResourcesetRelInfoExt) {
    this.roleResourcesetRelInfoExt = roleResourcesetRelInfoExt;
    return this;
  }

   /**
   * Get roleResourcesetRelInfoExt
   * @return roleResourcesetRelInfoExt
  **/
  @ApiModelProperty(value = "")
  public MsSysRoleResourcesetRelDTOExt getRoleResourcesetRelInfoExt() {
    return roleResourcesetRelInfoExt;
  }

  public void setRoleResourcesetRelInfoExt(MsSysRoleResourcesetRelDTOExt roleResourcesetRelInfoExt) {
    this.roleResourcesetRelInfoExt = roleResourcesetRelInfoExt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateRoleResourcesetRelRequest operateRoleResourcesetRelRequest = (MsOperateRoleResourcesetRelRequest) o;
    return Objects.equals(this.roleResourcesetRelInfoExt, operateRoleResourcesetRelRequest.roleResourcesetRelInfoExt) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roleResourcesetRelInfoExt, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateRoleResourcesetRelRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    roleResourcesetRelInfoExt: ").append(toIndentedString(roleResourcesetRelInfoExt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
