package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoIU;
import com.xforceplus.ucenter.client.model.MsSysSassSmsValidcodeDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateSmsValidCodeRequest extends MsDoIU {
  @JsonProperty("SmsValidCodeInfo")
  private MsSysSassSmsValidcodeDTO smsValidCodeInfo = null;

  @JsonIgnore
  public MsOperateSmsValidCodeRequest smsValidCodeInfo(MsSysSassSmsValidcodeDTO smsValidCodeInfo) {
    this.smsValidCodeInfo = smsValidCodeInfo;
    return this;
  }

   /**
   * Get smsValidCodeInfo
   * @return smsValidCodeInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysSassSmsValidcodeDTO getSmsValidCodeInfo() {
    return smsValidCodeInfo;
  }

  public void setSmsValidCodeInfo(MsSysSassSmsValidcodeDTO smsValidCodeInfo) {
    this.smsValidCodeInfo = smsValidCodeInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateSmsValidCodeRequest operateSmsValidCodeRequest = (MsOperateSmsValidCodeRequest) o;
    return Objects.equals(this.smsValidCodeInfo, operateSmsValidCodeRequest.smsValidCodeInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(smsValidCodeInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateSmsValidCodeRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    smsValidCodeInfo: ").append(toIndentedString(smsValidCodeInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
