package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoID;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateUserGroupRelUserRequest extends MsDoID {
  @JsonProperty("userGroupId")
  private Long userGroupId = null;

  @JsonProperty("userIds")
  private List<Long> userIds = new ArrayList<Long>();

  @JsonIgnore
  public MsOperateUserGroupRelUserRequest userGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
    return this;
  }

   /**
   * ID
   * @return userGroupId
  **/
  @ApiModelProperty(value = "ID")
  public Long getUserGroupId() {
    return userGroupId;
  }

  public void setUserGroupId(Long userGroupId) {
    this.userGroupId = userGroupId;
  }

  @JsonIgnore
  public MsOperateUserGroupRelUserRequest userIds(List<Long> userIds) {
    this.userIds = userIds;
    return this;
  }

  public MsOperateUserGroupRelUserRequest addUserIdsItem(Long userIdsItem) {
    this.userIds.add(userIdsItem);
    return this;
  }

   /**
   * 用户ids
   * @return userIds
  **/
  @ApiModelProperty(value = "用户ids")
  public List<Long> getUserIds() {
    return userIds;
  }

  public void setUserIds(List<Long> userIds) {
    this.userIds = userIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateUserGroupRelUserRequest operateUserGroupRelUserRequest = (MsOperateUserGroupRelUserRequest) o;
    return Objects.equals(this.userGroupId, operateUserGroupRelUserRequest.userGroupId) &&
        Objects.equals(this.userIds, operateUserGroupRelUserRequest.userIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userGroupId, userIds, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateUserGroupRelUserRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    userGroupId: ").append(toIndentedString(userGroupId)).append("\n");
    sb.append("    userIds: ").append(toIndentedString(userIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
