package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.ucenter.client.model.MsDoBase;
import com.xforceplus.ucenter.client.model.MsSysOrgUserRelDTO;
import com.xforceplus.ucenter.client.model.MsSysUserDTO;
import com.xforceplus.ucenter.client.model.MsUserTagModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOperateUserRequest extends MsDoBase {
  @JsonProperty("userInfo")
  private MsSysUserDTO userInfo = null;

  @JsonProperty("userOrgDTOs")
  private List<MsSysOrgUserRelDTO> userOrgDTOs = new ArrayList<MsSysOrgUserRelDTO>();

  @JsonProperty("roleIds")
  private String roleIds = null;

  @JsonProperty("userTags")
  private List<MsUserTagModel> userTags = new ArrayList<MsUserTagModel>();

  @JsonIgnore
  public MsOperateUserRequest userInfo(MsSysUserDTO userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * Get userInfo
   * @return userInfo
  **/
  @ApiModelProperty(value = "")
  public MsSysUserDTO getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsSysUserDTO userInfo) {
    this.userInfo = userInfo;
  }

  @JsonIgnore
  public MsOperateUserRequest userOrgDTOs(List<MsSysOrgUserRelDTO> userOrgDTOs) {
    this.userOrgDTOs = userOrgDTOs;
    return this;
  }

  public MsOperateUserRequest addUserOrgDTOsItem(MsSysOrgUserRelDTO userOrgDTOsItem) {
    this.userOrgDTOs.add(userOrgDTOsItem);
    return this;
  }

   /**
   * Get userOrgDTOs
   * @return userOrgDTOs
  **/
  @ApiModelProperty(value = "")
  public List<MsSysOrgUserRelDTO> getUserOrgDTOs() {
    return userOrgDTOs;
  }

  public void setUserOrgDTOs(List<MsSysOrgUserRelDTO> userOrgDTOs) {
    this.userOrgDTOs = userOrgDTOs;
  }

  @JsonIgnore
  public MsOperateUserRequest roleIds(String roleIds) {
    this.roleIds = roleIds;
    return this;
  }

   /**
   * 角色id集合
   * @return roleIds
  **/
  @ApiModelProperty(value = "角色id集合")
  public String getRoleIds() {
    return roleIds;
  }

  public void setRoleIds(String roleIds) {
    this.roleIds = roleIds;
  }

  @JsonIgnore
  public MsOperateUserRequest userTags(List<MsUserTagModel> userTags) {
    this.userTags = userTags;
    return this;
  }

  public MsOperateUserRequest addUserTagsItem(MsUserTagModel userTagsItem) {
    this.userTags.add(userTagsItem);
    return this;
  }

   /**
   * Get userTags
   * @return userTags
  **/
  @ApiModelProperty(value = "")
  public List<MsUserTagModel> getUserTags() {
    return userTags;
  }

  public void setUserTags(List<MsUserTagModel> userTags) {
    this.userTags = userTags;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateUserRequest operateUserRequest = (MsOperateUserRequest) o;
    return Objects.equals(this.userInfo, operateUserRequest.userInfo) &&
        Objects.equals(this.userOrgDTOs, operateUserRequest.userOrgDTOs) &&
        Objects.equals(this.roleIds, operateUserRequest.roleIds) &&
        Objects.equals(this.userTags, operateUserRequest.userTags) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userInfo, userOrgDTOs, roleIds, userTags, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateUserRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("    userOrgDTOs: ").append(toIndentedString(userOrgDTOs)).append("\n");
    sb.append("    roleIds: ").append(toIndentedString(roleIds)).append("\n");
    sb.append("    userTags: ").append(toIndentedString(userTags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
