package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ucenter.client.model.MsOrgTree;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsOrgTree {
  @JsonProperty("orgStructId")
  private String orgStructId = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("auditStatus")
  private String auditStatus = null;

  @JsonProperty("companyId")
  private String companyId = null;

  @JsonProperty("parentId")
  private String parentId = null;

  @JsonProperty("parentIds")
  private String parentIds = null;

  @JsonProperty("orgType")
  private String orgType = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("subOrgTrees")
  private List<MsOrgTree> subOrgTrees = new ArrayList<MsOrgTree>();

  @JsonIgnore
  public MsOrgTree orgStructId(String orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * 主键
   * @return orgStructId
  **/
  @ApiModelProperty(value = "主键")
  public String getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(String orgStructId) {
    this.orgStructId = orgStructId;
  }

  @JsonIgnore
  public MsOrgTree orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * 组织名称
   * @return orgName
  **/
  @ApiModelProperty(value = "组织名称")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public MsOrgTree auditStatus(String auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

   /**
   * 公司审核状态：0待审核，1审核通过,2审核失败
   * @return auditStatus
  **/
  @ApiModelProperty(value = "公司审核状态：0待审核，1审核通过,2审核失败")
  public String getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(String auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public MsOrgTree companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID")
  public String getCompanyId() {
    return companyId;
  }

  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsOrgTree parentId(String parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父节点ID
   * @return parentId
  **/
  @ApiModelProperty(value = "父节点ID")
  public String getParentId() {
    return parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsOrgTree parentIds(String parentIds) {
    this.parentIds = parentIds;
    return this;
  }

   /**
   * 父节点IDs
   * @return parentIds
  **/
  @ApiModelProperty(value = "父节点IDs")
  public String getParentIds() {
    return parentIds;
  }

  public void setParentIds(String parentIds) {
    this.parentIds = parentIds;
  }

  @JsonIgnore
  public MsOrgTree orgType(String orgType) {
    this.orgType = orgType;
    return this;
  }

   /**
   * 组织类型 0；集团 1：公司 2：其他组织
   * @return orgType
  **/
  @ApiModelProperty(value = "组织类型 0；集团 1：公司 2：其他组织")
  public String getOrgType() {
    return orgType;
  }

  public void setOrgType(String orgType) {
    this.orgType = orgType;
  }

  @JsonIgnore
  public MsOrgTree status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 启用状态： 1 启用 0 注销
   * @return status
  **/
  @ApiModelProperty(value = "启用状态： 1 启用 0 注销")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsOrgTree subOrgTrees(List<MsOrgTree> subOrgTrees) {
    this.subOrgTrees = subOrgTrees;
    return this;
  }

  public MsOrgTree addSubOrgTreesItem(MsOrgTree subOrgTreesItem) {
    this.subOrgTrees.add(subOrgTreesItem);
    return this;
  }

   /**
   * 组织子树
   * @return subOrgTrees
  **/
  @ApiModelProperty(value = "组织子树")
  public List<MsOrgTree> getSubOrgTrees() {
    return subOrgTrees;
  }

  public void setSubOrgTrees(List<MsOrgTree> subOrgTrees) {
    this.subOrgTrees = subOrgTrees;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOrgTree orgTree = (MsOrgTree) o;
    return Objects.equals(this.orgStructId, orgTree.orgStructId) &&
        Objects.equals(this.orgName, orgTree.orgName) &&
        Objects.equals(this.auditStatus, orgTree.auditStatus) &&
        Objects.equals(this.companyId, orgTree.companyId) &&
        Objects.equals(this.parentId, orgTree.parentId) &&
        Objects.equals(this.parentIds, orgTree.parentIds) &&
        Objects.equals(this.orgType, orgTree.orgType) &&
        Objects.equals(this.status, orgTree.status) &&
        Objects.equals(this.subOrgTrees, orgTree.subOrgTrees);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgStructId, orgName, auditStatus, companyId, parentId, parentIds, orgType, status, subOrgTrees);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOrgTree {\n");
    
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    parentIds: ").append(toIndentedString(parentIds)).append("\n");
    sb.append("    orgType: ").append(toIndentedString(orgType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    subOrgTrees: ").append(toIndentedString(subOrgTrees)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
