package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysIdentiSettingDTO {
  @JsonProperty("identiSettingId")
  private Long identiSettingId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("loginType")
  private Integer loginType = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysIdentiSettingDTO identiSettingId(Long identiSettingId) {
    this.identiSettingId = identiSettingId;
    return this;
  }

   /**
   * 自增主键
   * @return identiSettingId
  **/
  @ApiModelProperty(value = "自增主键")
  public Long getIdentiSettingId() {
    return identiSettingId;
  }

  public void setIdentiSettingId(Long identiSettingId) {
    this.identiSettingId = identiSettingId;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO loginType(Integer loginType) {
    this.loginType = loginType;
    return this;
  }

   /**
   * 登陆方式 0：手机登陆；1：邮箱登陆
   * @return loginType
  **/
  @ApiModelProperty(value = "登陆方式 0：手机登陆；1：邮箱登陆")
  public Integer getLoginType() {
    return loginType;
  }

  public void setLoginType(Integer loginType) {
    this.loginType = loginType;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysIdentiSettingDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysIdentiSettingDTO sysIdentiSettingDTO = (MsSysIdentiSettingDTO) o;
    return Objects.equals(this.identiSettingId, sysIdentiSettingDTO.identiSettingId) &&
        Objects.equals(this.tenantId, sysIdentiSettingDTO.tenantId) &&
        Objects.equals(this.loginType, sysIdentiSettingDTO.loginType) &&
        Objects.equals(this.createUserId, sysIdentiSettingDTO.createUserId) &&
        Objects.equals(this.createUserName, sysIdentiSettingDTO.createUserName) &&
        Objects.equals(this.createTime, sysIdentiSettingDTO.createTime) &&
        Objects.equals(this.updateUserId, sysIdentiSettingDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysIdentiSettingDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysIdentiSettingDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identiSettingId, tenantId, loginType, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysIdentiSettingDTO {\n");
    
    sb.append("    identiSettingId: ").append(toIndentedString(identiSettingId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    loginType: ").append(toIndentedString(loginType)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
