package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ucenter.client.model.MsSysMenuDTOExt;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysMenuDTOExt {
  @JsonProperty("menuId")
  private Long menuId = null;

  @JsonProperty("menuName")
  private String menuName = null;

  @JsonProperty("menuUrl")
  private String menuUrl = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("menuOrder")
  private Long menuOrder = null;

  @JsonProperty("menuDesc")
  private String menuDesc = null;

  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("children")
  private List<MsSysMenuDTOExt> children = new ArrayList<MsSysMenuDTOExt>();

  @JsonIgnore
  public MsSysMenuDTOExt menuId(Long menuId) {
    this.menuId = menuId;
    return this;
  }

   /**
   * 内部菜单id
   * @return menuId
  **/
  @ApiModelProperty(value = "内部菜单id")
  public Long getMenuId() {
    return menuId;
  }

  public void setMenuId(Long menuId) {
    this.menuId = menuId;
  }

  @JsonIgnore
  public MsSysMenuDTOExt menuName(String menuName) {
    this.menuName = menuName;
    return this;
  }

   /**
   * 菜单名称
   * @return menuName
  **/
  @ApiModelProperty(value = "菜单名称")
  public String getMenuName() {
    return menuName;
  }

  public void setMenuName(String menuName) {
    this.menuName = menuName;
  }

  @JsonIgnore
  public MsSysMenuDTOExt menuUrl(String menuUrl) {
    this.menuUrl = menuUrl;
    return this;
  }

   /**
   * 跳转地址
   * @return menuUrl
  **/
  @ApiModelProperty(value = "跳转地址")
  public String getMenuUrl() {
    return menuUrl;
  }

  public void setMenuUrl(String menuUrl) {
    this.menuUrl = menuUrl;
  }

  @JsonIgnore
  public MsSysMenuDTOExt parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父菜单ID
   * @return parentId
  **/
  @ApiModelProperty(value = "父菜单ID")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsSysMenuDTOExt menuOrder(Long menuOrder) {
    this.menuOrder = menuOrder;
    return this;
  }

   /**
   * 菜单顺序
   * @return menuOrder
  **/
  @ApiModelProperty(value = "菜单顺序")
  public Long getMenuOrder() {
    return menuOrder;
  }

  public void setMenuOrder(Long menuOrder) {
    this.menuOrder = menuOrder;
  }

  @JsonIgnore
  public MsSysMenuDTOExt menuDesc(String menuDesc) {
    this.menuDesc = menuDesc;
    return this;
  }

   /**
   * 菜单描述
   * @return menuDesc
  **/
  @ApiModelProperty(value = "菜单描述")
  public String getMenuDesc() {
    return menuDesc;
  }

  public void setMenuDesc(String menuDesc) {
    this.menuDesc = menuDesc;
  }

  @JsonIgnore
  public MsSysMenuDTOExt resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码ID
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码ID")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsSysMenuDTOExt status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 角色状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "角色状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysMenuDTOExt statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysMenuDTOExt createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysMenuDTOExt createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysMenuDTOExt createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysMenuDTOExt updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysMenuDTOExt updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysMenuDTOExt updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsSysMenuDTOExt children(List<MsSysMenuDTOExt> children) {
    this.children = children;
    return this;
  }

  public MsSysMenuDTOExt addChildrenItem(MsSysMenuDTOExt childrenItem) {
    this.children.add(childrenItem);
    return this;
  }

   /**
   * 组织子树
   * @return children
  **/
  @ApiModelProperty(value = "组织子树")
  public List<MsSysMenuDTOExt> getChildren() {
    return children;
  }

  public void setChildren(List<MsSysMenuDTOExt> children) {
    this.children = children;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysMenuDTOExt sysMenuDTOExt = (MsSysMenuDTOExt) o;
    return Objects.equals(this.menuId, sysMenuDTOExt.menuId) &&
        Objects.equals(this.menuName, sysMenuDTOExt.menuName) &&
        Objects.equals(this.menuUrl, sysMenuDTOExt.menuUrl) &&
        Objects.equals(this.parentId, sysMenuDTOExt.parentId) &&
        Objects.equals(this.menuOrder, sysMenuDTOExt.menuOrder) &&
        Objects.equals(this.menuDesc, sysMenuDTOExt.menuDesc) &&
        Objects.equals(this.resourceId, sysMenuDTOExt.resourceId) &&
        Objects.equals(this.status, sysMenuDTOExt.status) &&
        Objects.equals(this.statusTime, sysMenuDTOExt.statusTime) &&
        Objects.equals(this.createUserId, sysMenuDTOExt.createUserId) &&
        Objects.equals(this.createUserName, sysMenuDTOExt.createUserName) &&
        Objects.equals(this.createTime, sysMenuDTOExt.createTime) &&
        Objects.equals(this.updateUserId, sysMenuDTOExt.updateUserId) &&
        Objects.equals(this.updateUserName, sysMenuDTOExt.updateUserName) &&
        Objects.equals(this.updateTime, sysMenuDTOExt.updateTime) &&
        Objects.equals(this.children, sysMenuDTOExt.children);
  }

  @Override
  public int hashCode() {
    return Objects.hash(menuId, menuName, menuUrl, parentId, menuOrder, menuDesc, resourceId, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime, children);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysMenuDTOExt {\n");
    
    sb.append("    menuId: ").append(toIndentedString(menuId)).append("\n");
    sb.append("    menuName: ").append(toIndentedString(menuName)).append("\n");
    sb.append("    menuUrl: ").append(toIndentedString(menuUrl)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    menuOrder: ").append(toIndentedString(menuOrder)).append("\n");
    sb.append("    menuDesc: ").append(toIndentedString(menuDesc)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
