package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysOrgStructDTO {
  @JsonProperty("orgStructId")
  private Long orgStructId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxNum")
  private String taxNum;

  @JsonProperty("orgCode")
  private String orgCode = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("parentIds")
  private String parentIds = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("orgLevel")
  private Integer orgLevel = null;

  @JsonProperty("orgType")
  private Integer orgType = null;

  @JsonProperty("orgDesc")
  private String orgDesc = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("auditStatus")
  private Integer auditStatus = null;

  @JsonProperty("enabledTime")
  private String enabledTime = null;

  @JsonProperty("disabledTime")
  private String disabledTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysOrgStructDTO orgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

  /**
   * 自增主键
   * @return orgStructId
   **/
  @ApiModelProperty(value = "自增主键")
  public Long getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
  }

  @JsonIgnore
  public MsSysOrgStructDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * 集团ID
   * @return tenantId
   **/
  @ApiModelProperty(value = "集团ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysOrgStructDTO companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

  /**
   * 企业ID
   * @return companyId
   **/
  @ApiModelProperty(value = "企业ID")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsSysOrgStructDTO orgCode(String orgCode) {
    this.orgCode = orgCode;
    return this;
  }

  @ApiModelProperty(value = "企业名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @ApiModelProperty(value = "企业税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  /**
   * 组织代码
   * @return orgCode
   **/
  @ApiModelProperty(value = "组织代码")
  public String getOrgCode() {
    return orgCode;
  }

  public void setOrgCode(String orgCode) {
    this.orgCode = orgCode;
  }

  @JsonIgnore
  public MsSysOrgStructDTO orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

  /**
   * 组织名称
   * @return orgName
   **/
  @ApiModelProperty(value = "组织名称")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public MsSysOrgStructDTO parentIds(String parentIds) {
    this.parentIds = parentIds;
    return this;
  }

  /**
   * 当前节点以上节点集合
   * @return parentIds
   **/
  @ApiModelProperty(value = "当前节点以上节点集合")
  public String getParentIds() {
    return parentIds;
  }

  public void setParentIds(String parentIds) {
    this.parentIds = parentIds;
  }

  @JsonIgnore
  public MsSysOrgStructDTO parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

  /**
   * 上级组织 根节点=0
   * @return parentId
   **/
  @ApiModelProperty(value = "上级组织 根节点=0")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsSysOrgStructDTO orgLevel(Integer orgLevel) {
    this.orgLevel = orgLevel;
    return this;
  }

  /**
   * 层级 根节点=0
   * @return orgLevel
   **/
  @ApiModelProperty(value = "层级 根节点=0")
  public Integer getOrgLevel() {
    return orgLevel;
  }

  public void setOrgLevel(Integer orgLevel) {
    this.orgLevel = orgLevel;
  }

  @JsonIgnore
  public MsSysOrgStructDTO orgType(Integer orgType) {
    this.orgType = orgType;
    return this;
  }

  /**
   * 组织类型 0；集团 1：公司 2：其他组织
   * @return orgType
   **/
  @ApiModelProperty(value = "组织类型 0；集团 1：公司 2：其他组织")
  public Integer getOrgType() {
    return orgType;
  }

  public void setOrgType(Integer orgType) {
    this.orgType = orgType;
  }

  @JsonIgnore
  public MsSysOrgStructDTO orgDesc(String orgDesc) {
    this.orgDesc = orgDesc;
    return this;
  }

  /**
   * 组织备注
   * @return orgDesc
   **/
  @ApiModelProperty(value = "组织备注")
  public String getOrgDesc() {
    return orgDesc;
  }

  public void setOrgDesc(String orgDesc) {
    this.orgDesc = orgDesc;
  }

  @JsonIgnore
  public MsSysOrgStructDTO status(Integer status) {
    this.status = status;
    return this;
  }

  /**
   * 状态：0 未启用 1 启用 2 禁用
   * @return status
   **/
  @ApiModelProperty(value = "状态：0 未启用 1 启用 2 禁用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysOrgStructDTO auditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

  /**
   * 公司审核状态：0待审核，1审核通过,2审核失败
   * @return auditStatus
   **/
  @ApiModelProperty(value = "公司审核状态：0待审核，1审核通过,2审核失败")
  public Integer getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public MsSysOrgStructDTO enabledTime(String enabledTime) {
    this.enabledTime = enabledTime;
    return this;
  }

  /**
   * 状态启用时间
   * @return enabledTime
   **/
  @ApiModelProperty(value = "状态启用时间")
  public String getEnabledTime() {
    return enabledTime;
  }

  public void setEnabledTime(String enabledTime) {
    this.enabledTime = enabledTime;
  }

  @JsonIgnore
  public MsSysOrgStructDTO disabledTime(String disabledTime) {
    this.disabledTime = disabledTime;
    return this;
  }

  /**
   * 状态注销时间
   * @return disabledTime
   **/
  @ApiModelProperty(value = "状态注销时间")
  public String getDisabledTime() {
    return disabledTime;
  }

  public void setDisabledTime(String disabledTime) {
    this.disabledTime = disabledTime;
  }

  @JsonIgnore
  public MsSysOrgStructDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

  /**
   * 创建人ID
   * @return createUserId
   **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysOrgStructDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

  /**
   * 创建人姓名
   * @return createUserName
   **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysOrgStructDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * 创建时间
   * @return createTime
   **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysOrgStructDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

  /**
   * 更新人ID
   * @return updateUserId
   **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysOrgStructDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

  /**
   * 更新人姓名
   * @return updateUserName
   **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysOrgStructDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  /**
   * 更新时间
   * @return updateTime
   **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysOrgStructDTO sysOrgStructDTO = (MsSysOrgStructDTO) o;
    return Objects.equals(this.orgStructId, sysOrgStructDTO.orgStructId) &&
            Objects.equals(this.tenantId, sysOrgStructDTO.tenantId) &&
            Objects.equals(this.companyId, sysOrgStructDTO.companyId) &&
            Objects.equals(this.orgCode, sysOrgStructDTO.orgCode) &&
            Objects.equals(this.orgName, sysOrgStructDTO.orgName) &&
            Objects.equals(this.parentIds, sysOrgStructDTO.parentIds) &&
            Objects.equals(this.parentId, sysOrgStructDTO.parentId) &&
            Objects.equals(this.orgLevel, sysOrgStructDTO.orgLevel) &&
            Objects.equals(this.orgType, sysOrgStructDTO.orgType) &&
            Objects.equals(this.orgDesc, sysOrgStructDTO.orgDesc) &&
            Objects.equals(this.status, sysOrgStructDTO.status) &&
            Objects.equals(this.auditStatus, sysOrgStructDTO.auditStatus) &&
            Objects.equals(this.enabledTime, sysOrgStructDTO.enabledTime) &&
            Objects.equals(this.disabledTime, sysOrgStructDTO.disabledTime) &&
            Objects.equals(this.createUserId, sysOrgStructDTO.createUserId) &&
            Objects.equals(this.createUserName, sysOrgStructDTO.createUserName) &&
            Objects.equals(this.createTime, sysOrgStructDTO.createTime) &&
            Objects.equals(this.updateUserId, sysOrgStructDTO.updateUserId) &&
            Objects.equals(this.updateUserName, sysOrgStructDTO.updateUserName) &&
            Objects.equals(this.updateTime, sysOrgStructDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgStructId, tenantId, companyId, orgCode, orgName, parentIds, parentId, orgLevel, orgType, orgDesc, status, auditStatus, enabledTime, disabledTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysOrgStructDTO {\n");

    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    parentIds: ").append(toIndentedString(parentIds)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    orgLevel: ").append(toIndentedString(orgLevel)).append("\n");
    sb.append("    orgType: ").append(toIndentedString(orgType)).append("\n");
    sb.append("    orgDesc: ").append(toIndentedString(orgDesc)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    enabledTime: ").append(toIndentedString(enabledTime)).append("\n");
    sb.append("    disabledTime: ").append(toIndentedString(disabledTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
