package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysResourceDTO {
  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("appId")
  private Long appId = null;

  @JsonProperty("resourceCode")
  private String resourceCode = null;

  @JsonProperty("resourceName")
  private String resourceName = null;

  @JsonProperty("resourcePlatform")
  private Integer resourcePlatform = null;

  @JsonProperty("resourceType")
  private Integer resourceType = null;

  @JsonProperty("isServicePackage")
  private Integer isServicePackage = null;

  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysResourceDTO resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码ID
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码ID")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsSysResourceDTO appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 产线id
   * @return appId
  **/
  @ApiModelProperty(value = "产线id")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsSysResourceDTO resourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
    return this;
  }

   /**
   * 资源码CODE
   * @return resourceCode
  **/
  @ApiModelProperty(value = "资源码CODE")
  public String getResourceCode() {
    return resourceCode;
  }

  public void setResourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
  }

  @JsonIgnore
  public MsSysResourceDTO resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

   /**
   * 资源码名称
   * @return resourceName
  **/
  @ApiModelProperty(value = "资源码名称")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  @JsonIgnore
  public MsSysResourceDTO resourcePlatform(Integer resourcePlatform) {
    this.resourcePlatform = resourcePlatform;
    return this;
  }

   /**
   * 所属平台：0:进项 1:销项 2:物流 3:菜单 4:系统设置 5.BI 6.基础信息 7.公共 8.其他
   * @return resourcePlatform
  **/
  @ApiModelProperty(value = "所属平台：0:进项 1:销项 2:物流 3:菜单 4:系统设置 5.BI 6.基础信息 7.公共 8.其他")
  public Integer getResourcePlatform() {
    return resourcePlatform;
  }

  public void setResourcePlatform(Integer resourcePlatform) {
    this.resourcePlatform = resourcePlatform;
  }

  @JsonIgnore
  public MsSysResourceDTO resourceType(Integer resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 资源码类型：0:url 1:模块 2:页面，3页签，4按钮，5菜单，6服务
   * @return resourceType
  **/
  @ApiModelProperty(value = "资源码类型：0:url 1:模块 2:页面，3页签，4按钮，5菜单，6服务")
  public Integer getResourceType() {
    return resourceType;
  }

  public void setResourceType(Integer resourceType) {
    this.resourceType = resourceType;
  }

  @JsonIgnore
  public MsSysResourceDTO isServicePackage(Integer isServicePackage) {
    this.isServicePackage = isServicePackage;
    return this;
  }

   /**
   * 是否和服务包做交集
   * @return isServicePackage
  **/
  @ApiModelProperty(value = "是否和服务包做交集")
  public Integer getIsServicePackage() {
    return isServicePackage;
  }

  public void setIsServicePackage(Integer isServicePackage) {
    this.isServicePackage = isServicePackage;
  }

  @JsonIgnore
  public MsSysResourceDTO parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父资源码ID
   * @return parentId
  **/
  @ApiModelProperty(value = "父资源码ID")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MsSysResourceDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysResourceDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysResourceDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysResourceDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysResourceDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysResourceDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysResourceDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 修改人名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "修改人名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysResourceDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 修改时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "修改时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysResourceDTO sysResourceDTO = (MsSysResourceDTO) o;
    return Objects.equals(this.resourceId, sysResourceDTO.resourceId) &&
        Objects.equals(this.appId, sysResourceDTO.appId) &&
        Objects.equals(this.resourceCode, sysResourceDTO.resourceCode) &&
        Objects.equals(this.resourceName, sysResourceDTO.resourceName) &&
        Objects.equals(this.resourcePlatform, sysResourceDTO.resourcePlatform) &&
        Objects.equals(this.resourceType, sysResourceDTO.resourceType) &&
        Objects.equals(this.isServicePackage, sysResourceDTO.isServicePackage) &&
        Objects.equals(this.parentId, sysResourceDTO.parentId) &&
        Objects.equals(this.status, sysResourceDTO.status) &&
        Objects.equals(this.statusTime, sysResourceDTO.statusTime) &&
        Objects.equals(this.createUserId, sysResourceDTO.createUserId) &&
        Objects.equals(this.createUserName, sysResourceDTO.createUserName) &&
        Objects.equals(this.createTime, sysResourceDTO.createTime) &&
        Objects.equals(this.updateUserId, sysResourceDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysResourceDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysResourceDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceId, appId, resourceCode, resourceName, resourcePlatform, resourceType, isServicePackage, parentId, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysResourceDTO {\n");
    
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    resourceCode: ").append(toIndentedString(resourceCode)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    resourcePlatform: ").append(toIndentedString(resourcePlatform)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    isServicePackage: ").append(toIndentedString(isServicePackage)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
