package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysResourcesetDTO {
  @JsonProperty("resourcesetId")
  private Long resourcesetId = null;

  @JsonProperty("resourceId")
  private Long resourceId = null;

  @JsonProperty("appId")
  private Long appId = null;

  @JsonProperty("resourcesetName")
  private String resourcesetName = null;

  @JsonProperty("resourcesetDesc")
  private String resourcesetDesc = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysResourcesetDTO resourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
    return this;
  }

   /**
   * 功能点ID
   * @return resourcesetId
  **/
  @ApiModelProperty(value = "功能点ID")
  public Long getResourcesetId() {
    return resourcesetId;
  }

  public void setResourcesetId(Long resourcesetId) {
    this.resourcesetId = resourcesetId;
  }

  @JsonIgnore
  public MsSysResourcesetDTO resourceId(Long resourceId) {
    this.resourceId = resourceId;
    return this;
  }

   /**
   * 资源码模块ID
   * @return resourceId
  **/
  @ApiModelProperty(value = "资源码模块ID")
  public Long getResourceId() {
    return resourceId;
  }

  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  @JsonIgnore
  public MsSysResourcesetDTO appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 产线id
   * @return appId
  **/
  @ApiModelProperty(value = "产线id")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsSysResourcesetDTO resourcesetName(String resourcesetName) {
    this.resourcesetName = resourcesetName;
    return this;
  }

   /**
   * 功能点名称
   * @return resourcesetName
  **/
  @ApiModelProperty(value = "功能点名称")
  public String getResourcesetName() {
    return resourcesetName;
  }

  public void setResourcesetName(String resourcesetName) {
    this.resourcesetName = resourcesetName;
  }

  @JsonIgnore
  public MsSysResourcesetDTO resourcesetDesc(String resourcesetDesc) {
    this.resourcesetDesc = resourcesetDesc;
    return this;
  }

   /**
   * 描述
   * @return resourcesetDesc
  **/
  @ApiModelProperty(value = "描述")
  public String getResourcesetDesc() {
    return resourcesetDesc;
  }

  public void setResourcesetDesc(String resourcesetDesc) {
    this.resourcesetDesc = resourcesetDesc;
  }

  @JsonIgnore
  public MsSysResourcesetDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysResourcesetDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysResourcesetDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysResourcesetDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysResourcesetDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysResourcesetDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysResourcesetDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 修改人名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "修改人名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysResourcesetDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 修改时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "修改时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysResourcesetDTO sysResourcesetDTO = (MsSysResourcesetDTO) o;
    return Objects.equals(this.resourcesetId, sysResourcesetDTO.resourcesetId) &&
        Objects.equals(this.resourceId, sysResourcesetDTO.resourceId) &&
        Objects.equals(this.appId, sysResourcesetDTO.appId) &&
        Objects.equals(this.resourcesetName, sysResourcesetDTO.resourcesetName) &&
        Objects.equals(this.resourcesetDesc, sysResourcesetDTO.resourcesetDesc) &&
        Objects.equals(this.status, sysResourcesetDTO.status) &&
        Objects.equals(this.statusTime, sysResourcesetDTO.statusTime) &&
        Objects.equals(this.createUserId, sysResourcesetDTO.createUserId) &&
        Objects.equals(this.createUserName, sysResourcesetDTO.createUserName) &&
        Objects.equals(this.createTime, sysResourcesetDTO.createTime) &&
        Objects.equals(this.updateUserId, sysResourcesetDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysResourcesetDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysResourcesetDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourcesetId, resourceId, appId, resourcesetName, resourcesetDesc, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysResourcesetDTO {\n");
    
    sb.append("    resourcesetId: ").append(toIndentedString(resourcesetId)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    resourcesetName: ").append(toIndentedString(resourcesetName)).append("\n");
    sb.append("    resourcesetDesc: ").append(toIndentedString(resourcesetDesc)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
