package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRoleDTO {
  @JsonProperty("roleId")
  private Long roleId = null;

  @JsonProperty("roleCode")
  private String roleCode = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("roleName")
  private String roleName = null;

  @JsonProperty("roleDesc")
  private String roleDesc = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysRoleDTO roleId(Long roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 内部角色编号
   * @return roleId
  **/
  @ApiModelProperty(value = "内部角色编号")
  public Long getRoleId() {
    return roleId;
  }

  public void setRoleId(Long roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsSysRoleDTO roleCode(String roleCode) {
    this.roleCode = roleCode;
    return this;
  }

   /**
   * 角色代码
   * @return roleCode
  **/
  @ApiModelProperty(value = "角色代码")
  public String getRoleCode() {
    return roleCode;
  }

  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }

  @JsonIgnore
  public MsSysRoleDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysRoleDTO roleName(String roleName) {
    this.roleName = roleName;
    return this;
  }

   /**
   * 角色名称
   * @return roleName
  **/
  @ApiModelProperty(value = "角色名称")
  public String getRoleName() {
    return roleName;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  @JsonIgnore
  public MsSysRoleDTO roleDesc(String roleDesc) {
    this.roleDesc = roleDesc;
    return this;
  }

   /**
   * 角色功能描述
   * @return roleDesc
  **/
  @ApiModelProperty(value = "角色功能描述")
  public String getRoleDesc() {
    return roleDesc;
  }

  public void setRoleDesc(String roleDesc) {
    this.roleDesc = roleDesc;
  }

  @JsonIgnore
  public MsSysRoleDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 角色状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "角色状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysRoleDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysRoleDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysRoleDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysRoleDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysRoleDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysRoleDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysRoleDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRoleDTO sysRoleDTO = (MsSysRoleDTO) o;
    return Objects.equals(this.roleId, sysRoleDTO.roleId) &&
        Objects.equals(this.roleCode, sysRoleDTO.roleCode) &&
        Objects.equals(this.tenantId, sysRoleDTO.tenantId) &&
        Objects.equals(this.roleName, sysRoleDTO.roleName) &&
        Objects.equals(this.roleDesc, sysRoleDTO.roleDesc) &&
        Objects.equals(this.status, sysRoleDTO.status) &&
        Objects.equals(this.statusTime, sysRoleDTO.statusTime) &&
        Objects.equals(this.createUserId, sysRoleDTO.createUserId) &&
        Objects.equals(this.createUserName, sysRoleDTO.createUserName) &&
        Objects.equals(this.createTime, sysRoleDTO.createTime) &&
        Objects.equals(this.updateUserId, sysRoleDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysRoleDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysRoleDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roleId, roleCode, tenantId, roleName, roleDesc, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRoleDTO {\n");
    
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    roleCode: ").append(toIndentedString(roleCode)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    roleName: ").append(toIndentedString(roleName)).append("\n");
    sb.append("    roleDesc: ").append(toIndentedString(roleDesc)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
