package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRoleResourcesetRelDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("roleId")
  private Long roleId = null;

  @JsonProperty("resousesetId")
  private Long resousesetId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonIgnore
  public MsSysRoleResourcesetRelDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 关联编号
   * @return id
  **/
  @ApiModelProperty(value = "关联编号")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTO roleId(Long roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色ID
   * @return roleId
  **/
  @ApiModelProperty(value = "角色ID")
  public Long getRoleId() {
    return roleId;
  }

  public void setRoleId(Long roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTO resousesetId(Long resousesetId) {
    this.resousesetId = resousesetId;
    return this;
  }

   /**
   * 功能集ID
   * @return resousesetId
  **/
  @ApiModelProperty(value = "功能集ID")
  public Long getResousesetId() {
    return resousesetId;
  }

  public void setResousesetId(Long resousesetId) {
    this.resousesetId = resousesetId;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTO tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRoleResourcesetRelDTO sysRoleResourcesetRelDTO = (MsSysRoleResourcesetRelDTO) o;
    return Objects.equals(this.id, sysRoleResourcesetRelDTO.id) &&
        Objects.equals(this.roleId, sysRoleResourcesetRelDTO.roleId) &&
        Objects.equals(this.resousesetId, sysRoleResourcesetRelDTO.resousesetId) &&
        Objects.equals(this.tenantId, sysRoleResourcesetRelDTO.tenantId) &&
        Objects.equals(this.createUserId, sysRoleResourcesetRelDTO.createUserId) &&
        Objects.equals(this.createUserName, sysRoleResourcesetRelDTO.createUserName) &&
        Objects.equals(this.createTime, sysRoleResourcesetRelDTO.createTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, roleId, resousesetId, tenantId, createUserId, createUserName, createTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRoleResourcesetRelDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    resousesetId: ").append(toIndentedString(resousesetId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
