package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRoleResourcesetRelDTOExt {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("roleId")
  private Long roleId = null;

  @JsonProperty("resoucesetIds")
  private List<Long> resoucesetIds = new ArrayList<Long>();

  @JsonIgnore
  public MsSysRoleResourcesetRelDTOExt id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 关联编号
   * @return id
  **/
  @ApiModelProperty(value = "关联编号")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTOExt roleId(Long roleId) {
    this.roleId = roleId;
    return this;
  }

   /**
   * 角色ID
   * @return roleId
  **/
  @ApiModelProperty(value = "角色ID")
  public Long getRoleId() {
    return roleId;
  }

  public void setRoleId(Long roleId) {
    this.roleId = roleId;
  }

  @JsonIgnore
  public MsSysRoleResourcesetRelDTOExt resoucesetIds(List<Long> resoucesetIds) {
    this.resoucesetIds = resoucesetIds;
    return this;
  }

  public MsSysRoleResourcesetRelDTOExt addResoucesetIdsItem(Long resoucesetIdsItem) {
    this.resoucesetIds.add(resoucesetIdsItem);
    return this;
  }

   /**
   * 功能集ID列表
   * @return resoucesetIds
  **/
  @ApiModelProperty(value = "功能集ID列表")
  public List<Long> getResoucesetIds() {
    return resoucesetIds;
  }

  public void setResoucesetIds(List<Long> resoucesetIds) {
    this.resoucesetIds = resoucesetIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRoleResourcesetRelDTOExt sysRoleResourcesetRelDTOExt = (MsSysRoleResourcesetRelDTOExt) o;
    return Objects.equals(this.id, sysRoleResourcesetRelDTOExt.id) &&
        Objects.equals(this.roleId, sysRoleResourcesetRelDTOExt.roleId) &&
        Objects.equals(this.resoucesetIds, sysRoleResourcesetRelDTOExt.resoucesetIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, roleId, resoucesetIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRoleResourcesetRelDTOExt {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    roleId: ").append(toIndentedString(roleId)).append("\n");
    sb.append("    resoucesetIds: ").append(toIndentedString(resoucesetIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
