package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysServiceApiDTO {
  @JsonProperty("serviceApiId")
  private Long serviceApiId = null;

  @JsonProperty("appId")
  private Long appId = null;

  @JsonProperty("serviceApiPath")
  private String serviceApiPath = null;

  @JsonProperty("requestMethod")
  private String requestMethod = null;

  @JsonProperty("serviceApiUrl")
  private String serviceApiUrl = null;

  @JsonProperty("serviceApiName")
  private String serviceApiName = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsSysServiceApiDTO serviceApiId(Long serviceApiId) {
    this.serviceApiId = serviceApiId;
    return this;
  }

   /**
   * 服务Api ID
   * @return serviceApiId
  **/
  @ApiModelProperty(value = "服务Api ID")
  public Long getServiceApiId() {
    return serviceApiId;
  }

  public void setServiceApiId(Long serviceApiId) {
    this.serviceApiId = serviceApiId;
  }

  @JsonIgnore
  public MsSysServiceApiDTO appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 产线id
   * @return appId
  **/
  @ApiModelProperty(value = "产线id")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsSysServiceApiDTO serviceApiPath(String serviceApiPath) {
    this.serviceApiPath = serviceApiPath;
    return this;
  }

   /**
   * 服务 path
   * @return serviceApiPath
  **/
  @ApiModelProperty(value = "服务 path")
  public String getServiceApiPath() {
    return serviceApiPath;
  }

  public void setServiceApiPath(String serviceApiPath) {
    this.serviceApiPath = serviceApiPath;
  }

  @JsonIgnore
  public MsSysServiceApiDTO requestMethod(String requestMethod) {
    this.requestMethod = requestMethod;
    return this;
  }

   /**
   * 请求方法
   * @return requestMethod
  **/
  @ApiModelProperty(value = "请求方法")
  public String getRequestMethod() {
    return requestMethod;
  }

  public void setRequestMethod(String requestMethod) {
    this.requestMethod = requestMethod;
  }

  @JsonIgnore
  public MsSysServiceApiDTO serviceApiUrl(String serviceApiUrl) {
    this.serviceApiUrl = serviceApiUrl;
    return this;
  }

   /**
   * url
   * @return serviceApiUrl
  **/
  @ApiModelProperty(value = "url")
  public String getServiceApiUrl() {
    return serviceApiUrl;
  }

  public void setServiceApiUrl(String serviceApiUrl) {
    this.serviceApiUrl = serviceApiUrl;
  }

  @JsonIgnore
  public MsSysServiceApiDTO serviceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
    return this;
  }

   /**
   * 名称
   * @return serviceApiName
  **/
  @ApiModelProperty(value = "名称")
  public String getServiceApiName() {
    return serviceApiName;
  }

  public void setServiceApiName(String serviceApiName) {
    this.serviceApiName = serviceApiName;
  }

  @JsonIgnore
  public MsSysServiceApiDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "状态：1：正常，0：注销")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSysServiceApiDTO statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")
  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  @JsonIgnore
  public MsSysServiceApiDTO createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsSysServiceApiDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsSysServiceApiDTO createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysServiceApiDTO updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsSysServiceApiDTO updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 修改人名称
   * @return updateUserName
  **/
  @ApiModelProperty(value = "修改人名称")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsSysServiceApiDTO updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 修改时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "修改时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysServiceApiDTO sysServiceApiDTO = (MsSysServiceApiDTO) o;
    return Objects.equals(this.serviceApiId, sysServiceApiDTO.serviceApiId) &&
        Objects.equals(this.appId, sysServiceApiDTO.appId) &&
        Objects.equals(this.serviceApiPath, sysServiceApiDTO.serviceApiPath) &&
        Objects.equals(this.requestMethod, sysServiceApiDTO.requestMethod) &&
        Objects.equals(this.serviceApiUrl, sysServiceApiDTO.serviceApiUrl) &&
        Objects.equals(this.serviceApiName, sysServiceApiDTO.serviceApiName) &&
        Objects.equals(this.status, sysServiceApiDTO.status) &&
        Objects.equals(this.statusTime, sysServiceApiDTO.statusTime) &&
        Objects.equals(this.createUserId, sysServiceApiDTO.createUserId) &&
        Objects.equals(this.createUserName, sysServiceApiDTO.createUserName) &&
        Objects.equals(this.createTime, sysServiceApiDTO.createTime) &&
        Objects.equals(this.updateUserId, sysServiceApiDTO.updateUserId) &&
        Objects.equals(this.updateUserName, sysServiceApiDTO.updateUserName) &&
        Objects.equals(this.updateTime, sysServiceApiDTO.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serviceApiId, appId, serviceApiPath, requestMethod, serviceApiUrl, serviceApiName, status, statusTime, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysServiceApiDTO {\n");
    
    sb.append("    serviceApiId: ").append(toIndentedString(serviceApiId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    serviceApiPath: ").append(toIndentedString(serviceApiPath)).append("\n");
    sb.append("    requestMethod: ").append(toIndentedString(requestMethod)).append("\n");
    sb.append("    serviceApiUrl: ").append(toIndentedString(serviceApiUrl)).append("\n");
    sb.append("    serviceApiName: ").append(toIndentedString(serviceApiName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
