package com.xforceplus.ucenter.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysServiceApiDTOExt extends  MsSysServiceApiDTO{
  /**
   * 关联资源码数量
   */
  @JsonProperty("resourceCodeCount")
  private Long resourceCodeCount = null;


  @JsonIgnore
  public MsSysServiceApiDTOExt resourceCodeCount(Long resourceCodeCount) {
    this.resourceCodeCount = resourceCodeCount;
    return this;
  }

   /**
   * 资源码数量
   * @return resourceCodeCount
  **/
  @ApiModelProperty(value = "资源码数量")
  public Long getResourceCodeCount() {
    return resourceCodeCount;
  }

  public void setResourceCodeCount(Long resourceCodeCount) {
    this.resourceCodeCount = resourceCodeCount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysServiceApiDTOExt sysServiceApiDTO = (MsSysServiceApiDTOExt) o;
    return Objects.equals(this.resourceCodeCount, sysServiceApiDTO.resourceCodeCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceCodeCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysServiceApiDTO {\n");

    sb.append("    resourceCodeCount: ").append(toIndentedString(resourceCodeCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
