package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票批量查验返回对象
 */
@ApiModel(description = "发票批量查验返回对象")

@JsonInclude(NON_NULL)
public class MsBatchVerifyMain {
  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("success")
  private Integer success = null;

  @JsonProperty("fail")
  private Integer fail = null;

  @JsonIgnore
  public MsBatchVerifyMain total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 总数量
   * @return total
  **/
  @ApiModelProperty(value = "总数量")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsBatchVerifyMain success(Integer success) {
    this.success = success;
    return this;
  }

   /**
   * 成功数量
   * @return success
  **/
  @ApiModelProperty(value = "成功数量")
  public Integer getSuccess() {
    return success;
  }

  public void setSuccess(Integer success) {
    this.success = success;
  }

  @JsonIgnore
  public MsBatchVerifyMain fail(Integer fail) {
    this.fail = fail;
    return this;
  }

   /**
   * 失败数量
   * @return fail
  **/
  @ApiModelProperty(value = "失败数量")
  public Integer getFail() {
    return fail;
  }

  public void setFail(Integer fail) {
    this.fail = fail;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchVerifyMain batchVerifyMain = (MsBatchVerifyMain) o;
    return Objects.equals(this.total, batchVerifyMain.total) &&
        Objects.equals(this.success, batchVerifyMain.success) &&
        Objects.equals(this.fail, batchVerifyMain.fail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, success, fail);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchVerifyMain {\n");
    
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    fail: ").append(toIndentedString(fail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
