package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票信息查询条件
 */
@ApiModel(description = "发票信息查询条件")

@JsonInclude(NON_NULL)
public class MsInvoiceCriteria {
  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrewDateStart")
  private String paperDrewDateStart = null;

  @JsonProperty("paperDrewDateEnd")
  private String paperDrewDateEnd = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonIgnore
  public MsInvoiceCriteria invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsInvoiceCriteria paperDrewDateStart(String paperDrewDateStart) {
    this.paperDrewDateStart = paperDrewDateStart;
    return this;
  }

   /**
   * 开票日期开始时间
   * @return paperDrewDateStart
  **/
  @ApiModelProperty(value = "开票日期开始时间")
  public String getPaperDrewDateStart() {
    return paperDrewDateStart;
  }

  public void setPaperDrewDateStart(String paperDrewDateStart) {
    this.paperDrewDateStart = paperDrewDateStart;
  }

  @JsonIgnore
  public MsInvoiceCriteria paperDrewDateEnd(String paperDrewDateEnd) {
    this.paperDrewDateEnd = paperDrewDateEnd;
    return this;
  }

   /**
   * 开票日期结束时间
   * @return paperDrewDateEnd
  **/
  @ApiModelProperty(value = "开票日期结束时间")
  public String getPaperDrewDateEnd() {
    return paperDrewDateEnd;
  }

  public void setPaperDrewDateEnd(String paperDrewDateEnd) {
    this.paperDrewDateEnd = paperDrewDateEnd;
  }

  @JsonIgnore
  public MsInvoiceCriteria invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型: 增值税专用发票 s 增值税普通发票 c 增值税电子普通发票 ce 增值税普通发票（卷票） ju 通行费增值税电子普通发票 ct 机动车统一销售发票 v 
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型: 增值税专用发票 s 增值税普通发票 c 增值税电子普通发票 ce 增值税普通发票（卷票） ju 通行费增值税电子普通发票 ct 机动车统一销售发票 v ")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsInvoiceCriteria operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceCriteria invoiceCriteria = (MsInvoiceCriteria) o;
    return Objects.equals(this.invoiceNo, invoiceCriteria.invoiceNo) &&
        Objects.equals(this.paperDrewDateStart, invoiceCriteria.paperDrewDateStart) &&
        Objects.equals(this.paperDrewDateEnd, invoiceCriteria.paperDrewDateEnd) &&
        Objects.equals(this.invoiceType, invoiceCriteria.invoiceType) &&
        Objects.equals(this.operatorId, invoiceCriteria.operatorId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceNo, paperDrewDateStart, paperDrewDateEnd, invoiceType, operatorId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceCriteria {\n");
    
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    paperDrewDateStart: ").append(toIndentedString(paperDrewDateStart)).append("\n");
    sb.append("    paperDrewDateEnd: ").append(toIndentedString(paperDrewDateEnd)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
