package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票明细信息
 */
@ApiModel(description = "发票明细信息")

@JsonInclude(NON_NULL)
public class MsInvoiceDetail {
  @JsonProperty("cargoCode")
  private String cargoCode = null;

  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("quantity")
  private String quantity = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxRateType")
  private Integer taxRateType = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("plateNumber")
  private String plateNumber = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonProperty("tollStartDate")
  private String tollStartDate = null;

  @JsonProperty("tollEndDate")
  private String tollEndDate = null;

  @JsonProperty("licensePlateNum")
  private String licensePlateNum = null;

  @JsonProperty("type")
  private String type = null;

  @JsonProperty("currentDateStart")
  private String currentDateStart = null;

  @JsonProperty("currentDateEnd")
  private String currentDateEnd = null;

  @JsonProperty("goodsNoVer")
  private String goodsNoVer = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("shortTaxcodeStatus")
  private Integer shortTaxcodeStatus = null;

  @JsonIgnore
  public MsInvoiceDetail cargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
    return this;
  }

   /**
   * 货物或应税劳务代码
   * @return cargoCode
  **/
  @ApiModelProperty(value = "货物或应税劳务代码")
  public String getCargoCode() {
    return cargoCode;
  }

  public void setCargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
  }

  @JsonIgnore
  public MsInvoiceDetail cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或应税劳务名称
   * @return cargoName
  **/
  @ApiModelProperty(value = "货物或应税劳务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public MsInvoiceDetail itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public MsInvoiceDetail quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 数量单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "数量单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MsInvoiceDetail quantity(String quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public String getQuantity() {
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public MsInvoiceDetail unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public MsInvoiceDetail amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsInvoiceDetail taxRateType(Integer taxRateType) {
    this.taxRateType = taxRateType;
    return this;
  }

   /**
   * 0-非0税率（默认） 1-出口退税  2-免税  3-不征税   4-普通0税率
   * @return taxRateType
  **/
  @ApiModelProperty(value = "0-非0税率（默认） 1-出口退税  2-免税  3-不征税   4-普通0税率")
  public Integer getTaxRateType() {
    return taxRateType;
  }

  public void setTaxRateType(Integer taxRateType) {
    this.taxRateType = taxRateType;
  }

  @JsonIgnore
  public MsInvoiceDetail zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 税件税率类型：0-非0税率（默认） 1-出口退税  2-免税  3-不征税   4-普通0税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "税件税率类型：0-非0税率（默认） 1-出口退税  2-免税  3-不征税   4-普通0税率")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public MsInvoiceDetail taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsInvoiceDetail taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsInvoiceDetail amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsInvoiceDetail plateNumber(String plateNumber) {
    this.plateNumber = plateNumber;
    return this;
  }

   /**
   * 车牌号
   * @return plateNumber
  **/
  @ApiModelProperty(value = "车牌号")
  public String getPlateNumber() {
    return plateNumber;
  }

  public void setPlateNumber(String plateNumber) {
    this.plateNumber = plateNumber;
  }

  @JsonIgnore
  public MsInvoiceDetail vehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }

  @JsonIgnore
  public MsInvoiceDetail tollStartDate(String tollStartDate) {
    this.tollStartDate = tollStartDate;
    return this;
  }

   /**
   * 通行日期起
   * @return tollStartDate
  **/
  @ApiModelProperty(value = "通行日期起")
  public String getTollStartDate() {
    return tollStartDate;
  }

  public void setTollStartDate(String tollStartDate) {
    this.tollStartDate = tollStartDate;
  }

  @JsonIgnore
  public MsInvoiceDetail tollEndDate(String tollEndDate) {
    this.tollEndDate = tollEndDate;
    return this;
  }

   /**
   * 通行日期止
   * @return tollEndDate
  **/
  @ApiModelProperty(value = "通行日期止")
  public String getTollEndDate() {
    return tollEndDate;
  }

  public void setTollEndDate(String tollEndDate) {
    this.tollEndDate = tollEndDate;
  }

  @JsonIgnore
  public MsInvoiceDetail licensePlateNum(String licensePlateNum) {
    this.licensePlateNum = licensePlateNum;
    return this;
  }

   /**
   * 车牌号
   * @return licensePlateNum
  **/
  @ApiModelProperty(value = "车牌号")
  public String getLicensePlateNum() {
    return licensePlateNum;
  }

  public void setLicensePlateNum(String licensePlateNum) {
    this.licensePlateNum = licensePlateNum;
  }

  @JsonIgnore
  public MsInvoiceDetail type(String type) {
    this.type = type;
    return this;
  }

   /**
   * 车辆类型
   * @return type
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @JsonIgnore
  public MsInvoiceDetail currentDateStart(String currentDateStart) {
    this.currentDateStart = currentDateStart;
    return this;
  }

   /**
   * 通行日期起
   * @return currentDateStart
  **/
  @ApiModelProperty(value = "通行日期起")
  public String getCurrentDateStart() {
    return currentDateStart;
  }

  public void setCurrentDateStart(String currentDateStart) {
    this.currentDateStart = currentDateStart;
  }

  @JsonIgnore
  public MsInvoiceDetail currentDateEnd(String currentDateEnd) {
    this.currentDateEnd = currentDateEnd;
    return this;
  }

   /**
   * 通行日期止
   * @return currentDateEnd
  **/
  @ApiModelProperty(value = "通行日期止")
  public String getCurrentDateEnd() {
    return currentDateEnd;
  }

  public void setCurrentDateEnd(String currentDateEnd) {
    this.currentDateEnd = currentDateEnd;
  }

  @JsonIgnore
  public MsInvoiceDetail goodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
    return this;
  }

   /**
   * 编码版本号
   * @return goodsNoVer
  **/
  @ApiModelProperty(value = "编码版本号")
  public String getGoodsNoVer() {
    return goodsNoVer;
  }

  public void setGoodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
  }

  @JsonIgnore
  public MsInvoiceDetail goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public MsInvoiceDetail shortTaxcodeStatus(Integer shortTaxcodeStatus) {
    this.shortTaxcodeStatus = shortTaxcodeStatus;
    return this;
  }

   /**
   * 税编简称状态 0--合规 1--不合规
   * @return shortTaxcodeStatus
  **/
  @ApiModelProperty(value = "税编简称状态 0--合规 1--不合规")
  public Integer getShortTaxcodeStatus() {
    return shortTaxcodeStatus;
  }

  public void setShortTaxcodeStatus(Integer shortTaxcodeStatus) {
    this.shortTaxcodeStatus = shortTaxcodeStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceDetail invoiceDetail = (MsInvoiceDetail) o;
    return Objects.equals(this.cargoCode, invoiceDetail.cargoCode) &&
        Objects.equals(this.cargoName, invoiceDetail.cargoName) &&
        Objects.equals(this.itemSpec, invoiceDetail.itemSpec) &&
        Objects.equals(this.quantityUnit, invoiceDetail.quantityUnit) &&
        Objects.equals(this.quantity, invoiceDetail.quantity) &&
        Objects.equals(this.unitPrice, invoiceDetail.unitPrice) &&
        Objects.equals(this.amountWithoutTax, invoiceDetail.amountWithoutTax) &&
        Objects.equals(this.taxRateType, invoiceDetail.taxRateType) &&
        Objects.equals(this.zeroTax, invoiceDetail.zeroTax) &&
        Objects.equals(this.taxRate, invoiceDetail.taxRate) &&
        Objects.equals(this.taxAmount, invoiceDetail.taxAmount) &&
        Objects.equals(this.amountWithTax, invoiceDetail.amountWithTax) &&
        Objects.equals(this.plateNumber, invoiceDetail.plateNumber) &&
        Objects.equals(this.vehicleType, invoiceDetail.vehicleType) &&
        Objects.equals(this.tollStartDate, invoiceDetail.tollStartDate) &&
        Objects.equals(this.tollEndDate, invoiceDetail.tollEndDate) &&
        Objects.equals(this.licensePlateNum, invoiceDetail.licensePlateNum) &&
        Objects.equals(this.type, invoiceDetail.type) &&
        Objects.equals(this.currentDateStart, invoiceDetail.currentDateStart) &&
        Objects.equals(this.currentDateEnd, invoiceDetail.currentDateEnd) &&
        Objects.equals(this.goodsNoVer, invoiceDetail.goodsNoVer) &&
        Objects.equals(this.goodsTaxNo, invoiceDetail.goodsTaxNo) &&
        Objects.equals(this.shortTaxcodeStatus, invoiceDetail.shortTaxcodeStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cargoCode, cargoName, itemSpec, quantityUnit, quantity, unitPrice, amountWithoutTax, taxRateType, zeroTax, taxRate, taxAmount, amountWithTax, plateNumber, vehicleType, tollStartDate, tollEndDate, licensePlateNum, type, currentDateStart, currentDateEnd, goodsNoVer, goodsTaxNo, shortTaxcodeStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceDetail {\n");
    
    sb.append("    cargoCode: ").append(toIndentedString(cargoCode)).append("\n");
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxRateType: ").append(toIndentedString(taxRateType)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    plateNumber: ").append(toIndentedString(plateNumber)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("    tollStartDate: ").append(toIndentedString(tollStartDate)).append("\n");
    sb.append("    tollEndDate: ").append(toIndentedString(tollEndDate)).append("\n");
    sb.append("    licensePlateNum: ").append(toIndentedString(licensePlateNum)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    currentDateStart: ").append(toIndentedString(currentDateStart)).append("\n");
    sb.append("    currentDateEnd: ").append(toIndentedString(currentDateEnd)).append("\n");
    sb.append("    goodsNoVer: ").append(toIndentedString(goodsNoVer)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    shortTaxcodeStatus: ").append(toIndentedString(shortTaxcodeStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
