package com.xforceplus.phoenix.verify.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询发票list返回对象
 */
@ApiModel(description = "查询发票list返回对象")

@JsonInclude(NON_NULL)
public class MsInvoiceVerifyStatus {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("verifyStatus")
  private Integer verifyStatus = null;

  @JsonProperty("verifyRemark")
  private String verifyRemark = null;

  @JsonIgnore
  public MsInvoiceVerifyStatus invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 接口表主键
   * @return invoiceId
  **/
  @ApiModelProperty(value = "接口表主键")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public MsInvoiceVerifyStatus verifyStatus(Integer verifyStatus) {
    this.verifyStatus = verifyStatus;
    return this;
  }

   /**
   * 验真状态 0-验真中;1--验真成功;2--验真失败;3-验真请求发送失败
   * @return verifyStatus
  **/
  @ApiModelProperty(value = "验真状态 0-验真中;1--验真成功;2--验真失败;3-验真请求发送失败")
  public Integer getVerifyStatus() {
    return verifyStatus;
  }

  public void setVerifyStatus(Integer verifyStatus) {
    this.verifyStatus = verifyStatus;
  }

  @JsonIgnore
  public MsInvoiceVerifyStatus verifyRemark(String verifyRemark) {
    this.verifyRemark = verifyRemark;
    return this;
  }

   /**
   * 查验备注
   * @return verifyRemark
  **/
  @ApiModelProperty(value = "查验备注")
  public String getVerifyRemark() {
    return verifyRemark;
  }

  public void setVerifyRemark(String verifyRemark) {
    this.verifyRemark = verifyRemark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceVerifyStatus invoiceVerifyStatus = (MsInvoiceVerifyStatus) o;
    return Objects.equals(this.invoiceId, invoiceVerifyStatus.invoiceId) &&
        Objects.equals(this.verifyStatus, invoiceVerifyStatus.verifyStatus) &&
        Objects.equals(this.verifyRemark, invoiceVerifyStatus.verifyRemark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, verifyStatus, verifyRemark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceVerifyStatus {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    verifyStatus: ").append(toIndentedString(verifyStatus)).append("\n");
    sb.append("    verifyRemark: ").append(toIndentedString(verifyRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
